/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.CompatListenerAdapter;
import com.liulishuo.filedownloader.FileDownloadLargeFileListener;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.progress.ProgressAssist;
import com.liulishuo.filedownloader.retry.RetryAssist;
import com.liulishuo.filedownloader.status.StatusAssist;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.liulishuo.okdownload.DownloadListener;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.OkDownload;
import com.liulishuo.okdownload.core.IdentifiedTask;
import com.liulishuo.okdownload.core.Util;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadTaskAdapter
implements BaseDownloadTask,
BaseDownloadTask.IRunningTask {
    private static final int DEFAULT_CALLBACK_PROGRESS_COUNT = 100;
    static final int DEFAULT_CALLBACK_PROGRESS_MIN_INTERVAL_MILLIS = 10;
    private static final String TAG = "DownloadTaskAdapter";
    public static final int KEY_TASK_ADAPTER = Integer.MIN_VALUE;
    DownloadTask downloadTask;
    Builder builder;
    private List<BaseDownloadTask.FinishListener> finishListeners = new ArrayList<BaseDownloadTask.FinishListener>();
    FileDownloadListener listener;
    private CompatListenerAdapter compatListener;
    private int autoRetryTimes;
    private int callbackProgressCount = 100;
    StatusAssist statusAssist = new StatusAssist();
    private ProgressAssist progressAssist;
    private RetryAssist retryAssist;
    private volatile int attachKey;
    private volatile boolean isAddedToList;
    private final Object insureDownloadTaskAssembledLock = new Object();
    private Object tag;
    private SparseArray<Object> tagWithKey;

    public DownloadTaskAdapter(String url) {
        this.builder = new Builder();
        this.builder.url = url;
    }

    public ProgressAssist getProgressAssist() {
        return this.progressAssist;
    }

    public RetryAssist getRetryAssist() {
        return this.retryAssist;
    }

    public CompatListenerAdapter getCompatListener() {
        return this.compatListener;
    }

    @NonNull
    public DownloadTask getDownloadTask() {
        this.insureAssembleDownloadTask();
        return this.downloadTask;
    }

    public List<BaseDownloadTask.FinishListener> getFinishListeners() {
        return this.finishListeners;
    }

    @Override
    public BaseDownloadTask setMinIntervalUpdateSpeed(int minIntervalUpdateSpeedMs) {
        return this;
    }

    @Override
    public BaseDownloadTask setPath(String path) {
        this.builder.path = path;
        return this;
    }

    @Override
    public BaseDownloadTask setPath(String path, boolean pathAsDirectory) {
        this.builder.path = path;
        this.builder.pathAsDirectory = pathAsDirectory;
        return this;
    }

    @Override
    public BaseDownloadTask setListener(FileDownloadListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressTimes(int callbackProgressCount) {
        this.callbackProgressCount = callbackProgressCount;
        this.progressAssist = new ProgressAssist(callbackProgressCount);
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressMinInterval(int minIntervalMillis) {
        this.builder.minIntervalMillisCallbackProgress = minIntervalMillis;
        return this;
    }

    @Override
    public BaseDownloadTask setCallbackProgressIgnored() {
        this.setCallbackProgressTimes(-1);
        return this;
    }

    @Override
    public BaseDownloadTask setTag(Object tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public BaseDownloadTask setTag(int key, Object tag) {
        if (this.tagWithKey == null) {
            this.tagWithKey = new SparseArray();
        }
        this.tagWithKey.put(key, tag);
        return this;
    }

    @Override
    public BaseDownloadTask setForceReDownload(boolean isForceReDownload) {
        this.builder.forceReDownload = isForceReDownload;
        return this;
    }

    @Override
    public BaseDownloadTask setFinishListener(BaseDownloadTask.FinishListener finishListener) {
        this.addFinishListener(finishListener);
        return this;
    }

    @Override
    public BaseDownloadTask addFinishListener(BaseDownloadTask.FinishListener finishListener) {
        if (finishListener == null) {
            return this;
        }
        if (this.finishListeners.contains(finishListener)) {
            return this;
        }
        this.finishListeners.add(finishListener);
        return this;
    }

    @Override
    public boolean removeFinishListener(BaseDownloadTask.FinishListener finishListener) {
        return this.finishListeners.remove(finishListener);
    }

    @Override
    public BaseDownloadTask setAutoRetryTimes(int autoRetryTimes) {
        this.autoRetryTimes = autoRetryTimes;
        if (autoRetryTimes > 0) {
            this.retryAssist = new RetryAssist(autoRetryTimes);
        }
        return this;
    }

    @Override
    public BaseDownloadTask addHeader(String name, String value) {
        this.builder.headerMap.put(name, value);
        return this;
    }

    @Override
    public BaseDownloadTask addHeader(String line) {
        String[] parsed = line.split(":");
        String name = parsed[0].trim();
        String value = parsed[1].trim();
        this.addHeader(name, value);
        return this;
    }

    @Override
    public BaseDownloadTask removeAllHeaders(String name) {
        this.builder.headerMap.remove(name);
        return this;
    }

    @Override
    public BaseDownloadTask setSyncCallback(boolean syncCallback) {
        this.builder.autoCallbackToUIThread = !syncCallback;
        return this;
    }

    @Override
    public BaseDownloadTask setWifiRequired(boolean isWifiRequired) {
        this.builder.isWifiRequired = isWifiRequired;
        return this;
    }

    @Override
    @Deprecated
    public int ready() {
        return this.asInQueueTask().enqueue();
    }

    @Override
    public BaseDownloadTask.InQueueTask asInQueueTask() {
        return new InQueueTaskImpl(this);
    }

    @Override
    public boolean reuse() {
        if (this.isRunning()) {
            Util.w((String)TAG, (String)("This task[" + this.getId() + "] is running, if you want start the same task, please create a new one by FileDownloader#create"));
            return false;
        }
        this.attachKey = 0;
        this.isAddedToList = false;
        return true;
    }

    @Override
    public boolean isUsing() {
        return this.statusAssist.isUsing();
    }

    @Override
    public boolean isRunning() {
        if (this.downloadTask == null) {
            return false;
        }
        return OkDownload.with().downloadDispatcher().isRunning(this.downloadTask);
    }

    @Override
    public boolean isAttached() {
        return this.attachKey != 0;
    }

    @Override
    public int start() {
        this.insureAssembleDownloadTask();
        FileDownloadList.getImpl().addIndependentTask(this);
        this.downloadTask.enqueue((DownloadListener)this.compatListener);
        return this.downloadTask.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insureAssembleDownloadTask() {
        Object object = this.insureDownloadTaskAssembledLock;
        synchronized (object) {
            if (this.downloadTask != null) {
                return;
            }
        }
        this.downloadTask = this.builder.build();
        this.compatListener = CompatListenerAdapter.create(this.listener);
        if (this.progressAssist == null) {
            this.progressAssist = new ProgressAssist(this.callbackProgressCount);
        }
        this.statusAssist.setDownloadTask(this.downloadTask);
        this.downloadTask.addTag(Integer.MIN_VALUE, (Object)this);
    }

    @Override
    public boolean pause() {
        return this.cancel();
    }

    @Override
    public boolean cancel() {
        if (this.downloadTask == null) {
            return true;
        }
        return OkDownload.with().downloadDispatcher().cancel((IdentifiedTask)this.downloadTask);
    }

    @Override
    public int getId() {
        this.insureAssembleDownloadTask();
        return this.downloadTask.getId();
    }

    @Override
    public int getDownloadId() {
        return this.getId();
    }

    @Override
    public String getUrl() {
        return this.builder.url;
    }

    @Override
    public int getCallbackProgressTimes() {
        return this.callbackProgressCount;
    }

    @Override
    public int getCallbackProgressMinInterval() {
        return this.builder.minIntervalMillisCallbackProgress;
    }

    @Override
    public String getPath() {
        return this.builder.path;
    }

    @Override
    public boolean isPathAsDirectory() {
        return this.builder.pathAsDirectory;
    }

    @Override
    public String getFilename() {
        if (this.builder.pathAsDirectory) {
            return null;
        }
        return new File(this.builder.path).getName();
    }

    @Override
    public String getTargetFilePath() {
        return FileDownloadUtils.getTargetFilePath(this.builder.path, this.builder.pathAsDirectory, this.getFilename());
    }

    @Override
    public FileDownloadListener getListener() {
        return this.listener;
    }

    @Override
    public int getSoFarBytes() {
        return (int)this.getSoFarBytesInLong();
    }

    public long getSoFarBytesInLong() {
        if (this.downloadTask == null) {
            return 0L;
        }
        BreakpointInfo info = this.downloadTask.getInfo();
        if (info != null) {
            return info.getTotalOffset();
        }
        return 0L;
    }

    @Override
    public int getSmallFileSoFarBytes() {
        return (int)this.getLargeFileSoFarBytes();
    }

    @Override
    public long getLargeFileSoFarBytes() {
        if (this.progressAssist == null) {
            return 0L;
        }
        return this.progressAssist.getSofarBytes();
    }

    @Override
    public int getTotalBytes() {
        return (int)this.getTotalBytesInLong();
    }

    public long getTotalBytesInLong() {
        if (this.downloadTask == null) {
            return 0L;
        }
        BreakpointInfo info = this.downloadTask.getInfo();
        if (info != null) {
            return info.getTotalLength();
        }
        return 0L;
    }

    @Override
    public int getSmallFileTotalBytes() {
        return (int)this.getLargeFileTotalBytes();
    }

    @Override
    public long getLargeFileTotalBytes() {
        if (this.downloadTask == null) {
            return 0L;
        }
        BreakpointInfo info = this.downloadTask.getInfo();
        if (info != null) {
            return info.getTotalLength();
        }
        return 0L;
    }

    @Override
    public int getSpeed() {
        return (int)this.progressAssist.getSpeed();
    }

    @Override
    public byte getStatus() {
        return this.statusAssist.getStatus();
    }

    @Override
    public boolean isForceReDownload() {
        return this.builder.forceReDownload;
    }

    @Override
    public Throwable getEx() {
        return this.compatListener.getListenerAssist().getException();
    }

    @Override
    public Throwable getErrorCause() {
        return this.getEx();
    }

    @Override
    public boolean isReusedOldFile() {
        return this.compatListener.getListenerAssist().isReuseOldFile();
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public Object getTag(int key) {
        if (this.tagWithKey == null) {
            return null;
        }
        return this.tagWithKey.get(key);
    }

    @Override
    public boolean isContinue() {
        return this.isResuming();
    }

    @Override
    public boolean isResuming() {
        return this.compatListener.getListenerAssist().isResumable();
    }

    @Override
    public String getEtag() {
        return this.compatListener.getListenerAssist().getEtag();
    }

    @Override
    public int getAutoRetryTimes() {
        return this.autoRetryTimes;
    }

    @Override
    public int getRetryingTimes() {
        if (this.retryAssist != null) {
            return this.retryAssist.getRetriedTimes() + 1;
        }
        return 0;
    }

    @Override
    public boolean isSyncCallback() {
        return !this.builder.autoCallbackToUIThread;
    }

    @Override
    public boolean isLargeFile() {
        return this.listener instanceof FileDownloadLargeFileListener;
    }

    @Override
    public boolean isWifiRequired() {
        return this.builder.isWifiRequired;
    }

    @Override
    public BaseDownloadTask getOrigin() {
        return this;
    }

    @Override
    public ITaskHunter.IMessageHandler getMessageHandler() {
        return null;
    }

    @Override
    public boolean is(int id) {
        return this.getId() == id;
    }

    @Override
    public boolean is(FileDownloadListener listener) {
        return this.listener == listener;
    }

    @Override
    public boolean isOver() {
        return this.statusAssist.isOver();
    }

    @Override
    public int getAttachKey() {
        return this.attachKey;
    }

    @Override
    public void setAttachKeyByQueue(int key) {
        this.attachKey = key;
    }

    @Override
    public void setAttachKeyDefault() {
        int key = this.getListener() != null ? this.getListener().hashCode() : this.hashCode();
        this.attachKey = key;
    }

    @Override
    public boolean isMarkedAdded2List() {
        return this.isAddedToList;
    }

    @Override
    public void markAdded2List() {
        this.isAddedToList = true;
    }

    @Override
    public void free() {
    }

    @Override
    public void startTaskByQueue() {
    }

    @Override
    public void startTaskByRescue() {
    }

    @Override
    @Nullable
    public Object getPauseLock() {
        return null;
    }

    @Override
    public boolean isContainFinishListener() {
        return !this.finishListeners.isEmpty();
    }

    public void replaceListener(FileDownloadListener fileDownloadListener) {
        this.setListener(fileDownloadListener);
        if (this.downloadTask == null) {
            return;
        }
        this.compatListener = CompatListenerAdapter.create(this.listener);
        this.downloadTask.replaceListener((DownloadListener)this.compatListener);
    }

    static final class InQueueTaskImpl
    implements BaseDownloadTask.InQueueTask {
        final DownloadTaskAdapter downloadTaskAdapter;

        InQueueTaskImpl(DownloadTaskAdapter downloadTaskAdapter) {
            this.downloadTaskAdapter = downloadTaskAdapter;
        }

        @Override
        public int enqueue() {
            FileDownloadList.getImpl().addQueueTask(this.downloadTaskAdapter);
            return this.downloadTaskAdapter.getId();
        }
    }

    static final class Builder {
        private String url;
        String path;
        boolean pathAsDirectory;
        private int minIntervalMillisCallbackProgress = 10;
        private boolean forceReDownload;
        Map<String, String> headerMap = new HashMap<String, String>();
        private boolean isWifiRequired;
        private boolean autoCallbackToUIThread = true;

        Builder() {
        }

        DownloadTask build() {
            if (this.path == null) {
                this.path = FileDownloadUtils.getDefaultSaveFilePath(this.url);
            }
            DownloadTask.Builder builder = this.pathAsDirectory ? new DownloadTask.Builder(this.url, this.path, null) : new DownloadTask.Builder(this.url, new File(this.path));
            builder.setMinIntervalMillisCallbackProcess(this.minIntervalMillisCallbackProgress);
            builder.setPassIfAlreadyCompleted(!this.forceReDownload);
            builder.setWifiRequired(this.isWifiRequired);
            for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            builder.setAutoCallbackToUIThread(this.autoCallbackToUIThread);
            return builder.build();
        }
    }
}

