/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadTaskAdapter;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.liulishuo.okdownload.DownloadMonitor;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.cause.ResumeFailedCause;

public class FileDownloadMonitor {
    private static DownloadMonitorAdapter monitor;

    public static void setGlobalMonitor(@NonNull IMonitor monitor) {
        FileDownloadMonitor.monitor = new DownloadMonitorAdapter(monitor);
    }

    public static void releaseGlobalMonitor() {
        monitor = null;
    }

    public static IMonitor getMonitor() {
        return FileDownloadMonitor.monitor.callbackMonitor;
    }

    static DownloadMonitor getDownloadMonitor() {
        return monitor;
    }

    public static boolean isValid() {
        return FileDownloadMonitor.getDownloadMonitor() != null && FileDownloadMonitor.getMonitor() != null;
    }

    public static interface IMonitor {
        public void onRequestStart(int var1, boolean var2, FileDownloadListener var3);

        public void onRequestStart(BaseDownloadTask var1);

        public void onTaskBegin(BaseDownloadTask var1);

        public void onTaskStarted(BaseDownloadTask var1);

        public void onTaskOver(BaseDownloadTask var1);
    }

    static final class DownloadMonitorAdapter
    implements DownloadMonitor,
    IMonitor {
        @NonNull
        final IMonitor callbackMonitor;

        DownloadMonitorAdapter(IMonitor callbackMonitor) {
            this.callbackMonitor = callbackMonitor;
        }

        public void taskStart(DownloadTask task) {
            DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
            if (downloadTaskAdapter != null) {
                this.onTaskBegin(downloadTaskAdapter);
            }
        }

        public void taskDownloadFromBreakpoint(@NonNull DownloadTask task, @NonNull BreakpointInfo info) {
            this.taskDownloadFromBeginning(task, info, null);
        }

        public void taskDownloadFromBeginning(@NonNull DownloadTask task, @NonNull BreakpointInfo info, @Nullable ResumeFailedCause cause) {
            DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
            if (downloadTaskAdapter != null) {
                this.onRequestStart(downloadTaskAdapter);
                this.onTaskStarted(downloadTaskAdapter);
            }
        }

        public void taskEnd(DownloadTask task, EndCause cause, @Nullable Exception realCause) {
            DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
            if (downloadTaskAdapter != null) {
                this.onTaskOver(downloadTaskAdapter);
            }
        }

        @Override
        public void onRequestStart(int count, boolean serial, FileDownloadListener lis) {
            this.callbackMonitor.onRequestStart(count, serial, lis);
        }

        @Override
        public void onRequestStart(BaseDownloadTask task) {
            this.callbackMonitor.onRequestStart(task);
        }

        @Override
        public void onTaskBegin(BaseDownloadTask task) {
            this.callbackMonitor.onTaskBegin(task);
        }

        @Override
        public void onTaskStarted(BaseDownloadTask task) {
            this.callbackMonitor.onTaskStarted(task);
        }

        @Override
        public void onTaskOver(BaseDownloadTask task) {
            this.callbackMonitor.onTaskOver(task);
        }
    }
}

