/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.app.Application;
import android.app.Notification;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.CompatListenerAdapter;
import com.liulishuo.filedownloader.DownloadTaskAdapter;
import com.liulishuo.filedownloader.FileDownloadConnectListener;
import com.liulishuo.filedownloader.FileDownloadLine;
import com.liulishuo.filedownloader.FileDownloadLineAsync;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMonitor;
import com.liulishuo.filedownloader.services.DownloadMgrInitialParams;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.liulishuo.okdownload.DownloadContext;
import com.liulishuo.okdownload.DownloadContextListener;
import com.liulishuo.okdownload.DownloadListener;
import com.liulishuo.okdownload.DownloadMonitor;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.OkDownload;
import com.liulishuo.okdownload.StatusUtil;
import com.liulishuo.okdownload.core.IdentifiedTask;
import com.liulishuo.okdownload.core.Util;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.connection.DownloadOkHttp3Connection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;

public class FileDownloader {
    private static final String TAG = "FileDownloader";
    private static final String FILEDOWNLOADER_DATABASE_NAME = "filedownloader.db";
    private static final int DEFAULT_INTERVAL = 10;
    private static int globalPost2UIInterval = -1;

    public static FileDownloader getImpl() {
        return HolderClass.INSTANCE;
    }

    public static void init(@NonNull Context context) {
        FileDownloader.init(context, null);
    }

    public static void init(@NonNull Context context, @Nullable FileDownloadHelper.OkHttpClientCustomMaker okHttpClientCustomMaker) {
        FileDownloader.init(context, okHttpClientCustomMaker, 0);
    }

    public static void init(@NonNull Context context, @Nullable FileDownloadHelper.OkHttpClientCustomMaker okHttpClientCustomMaker, int maxNetworkThreadCount) {
        FileDownloader.setup(context);
        OkDownload.Builder builder = FileDownloader.okDownloadBuilder(context, okHttpClientCustomMaker);
        if (builder != null) {
            OkDownload.setSingletonInstance((OkDownload)builder.build());
        }
    }

    @Nullable
    public static OkDownload.Builder okDownloadBuilder(@NonNull Context context, @Nullable FileDownloadHelper.OkHttpClientCustomMaker okHttpClientCustomMaker) {
        DownloadMonitor downloadMonitor;
        OkDownload.Builder builder = null;
        OkHttpClient okHttpClient = okHttpClientCustomMaker == null ? null : okHttpClientCustomMaker.customMake();
        if (okHttpClient != null) {
            builder = new OkDownload.Builder(context);
            builder.connectionFactory(url -> new DownloadOkHttp3Connection.Factory().setBuilder(okHttpClient.newBuilder()).create(url));
        }
        if ((downloadMonitor = FileDownloadMonitor.getDownloadMonitor()) != null) {
            if (builder == null) {
                builder = new OkDownload.Builder(context);
            }
            builder.monitor(downloadMonitor);
        }
        return builder;
    }

    public static void setup(@NonNull Context context) {
        FileDownloadHelper.holdContext(context.getApplicationContext());
    }

    public static DownloadMgrInitialParams.InitCustomMaker setupOnApplicationOnCreate(Application application) {
        Context context = application.getApplicationContext();
        DownloadMgrInitialParams.InitCustomMaker customMaker = new DownloadMgrInitialParams.InitCustomMaker(context);
        return customMaker;
    }

    public DownloadTaskAdapter create(String url) {
        DownloadTaskAdapter taskAdapter = new DownloadTaskAdapter(url);
        if (globalPost2UIInterval > 0) {
            taskAdapter.setCallbackProgressMinInterval(globalPost2UIInterval);
        }
        return taskAdapter;
    }

    public boolean start(FileDownloadListener listener, boolean isSerial) {
        if (listener == null) {
            Util.w((String)TAG, (String)("Tasks with the listener can't start, because the listener provided is null: [null, " + isSerial + "]"));
            return false;
        }
        List<DownloadTaskAdapter> originalTasks = FileDownloadList.getImpl().assembleTasksToStart(listener);
        if (originalTasks.isEmpty()) {
            Util.w((String)TAG, (String)("no task for listener: " + listener + " to start"));
            return false;
        }
        ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>();
        for (DownloadTaskAdapter task : originalTasks) {
            downloadTasks.add(task.getDownloadTask());
        }
        DownloadContext downloadContext = new DownloadContext.Builder(new DownloadContext.QueueSet(), downloadTasks).setListener(new DownloadContextListener(){

            public void taskEnd(@NonNull DownloadContext context, @NonNull DownloadTask task, @NonNull EndCause cause, @Nullable Exception realCause, int remainCount) {
                Util.d((String)FileDownloader.TAG, (String)("task " + task.getId() + "end"));
                DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
                if (downloadTaskAdapter != null) {
                    FileDownloadList.getImpl().remove(downloadTaskAdapter);
                }
            }

            public void queueEnd(@NonNull DownloadContext context) {
                Util.d((String)FileDownloader.TAG, (String)"queue end");
            }
        }).build();
        CompatListenerAdapter compatListenerAdapter = CompatListenerAdapter.create(listener);
        downloadContext.start((DownloadListener)compatListenerAdapter, isSerial);
        return true;
    }

    @Deprecated
    public void bindService() {
    }

    @Deprecated
    public void unbindService() {
    }

    @Deprecated
    public void unBindServiceIfIdle() {
    }

    @Deprecated
    public boolean isServiceConnected() {
        return true;
    }

    @Deprecated
    public void addServiceConnectListener(FileDownloadConnectListener connectListener) {
    }

    @Deprecated
    public void removeServiceConnectListener(FileDownloadConnectListener connectListener) {
    }

    @Deprecated
    public void startForeground(int id, Notification notification) {
    }

    @Deprecated
    public void stopForeground(boolean removeNotification) {
    }

    @Deprecated
    public boolean setMaxNetworkThreadCount(int count) {
        return false;
    }

    @Deprecated
    public void bindService(Runnable runnable) {
        runnable.run();
    }

    public void pause(FileDownloadListener listener) {
        List<DownloadTaskAdapter> taskAdapters = FileDownloadList.getImpl().getByFileDownloadListener(listener);
        DownloadTask[] downloadTasks = new DownloadTask[taskAdapters.size()];
        for (int i = 0; i < taskAdapters.size(); ++i) {
            downloadTasks[i] = taskAdapters.get(i).getDownloadTask();
        }
        OkDownload.with().downloadDispatcher().cancel((IdentifiedTask[])downloadTasks);
    }

    public void pauseAll() {
        OkDownload.with().downloadDispatcher().cancelAll();
    }

    public int pause(int id) {
        OkDownload.with().downloadDispatcher().cancel(id);
        return 0;
    }

    public static void setGlobalPost2UIInterval(int intervalMillisecond) {
        globalPost2UIInterval = intervalMillisecond;
    }

    @Deprecated
    public static void setGlobalHandleSubPackageSize(int packageSize) {
    }

    public static void enableAvoidDropFrame() {
        FileDownloader.setGlobalPost2UIInterval(10);
    }

    public static void disableAvoidDropFrame() {
        FileDownloader.setGlobalPost2UIInterval(-1);
    }

    public static boolean isEnabledAvoidDropFrame() {
        return globalPost2UIInterval > 0;
    }

    public long getSoFar(int downloadId) {
        BreakpointInfo info = OkDownload.with().breakpointStore().get(downloadId);
        if (info == null) {
            return 0L;
        }
        return info.getTotalOffset();
    }

    public long getTotal(int id) {
        BreakpointInfo info = OkDownload.with().breakpointStore().get(id);
        if (info == null) {
            return 0L;
        }
        return info.getTotalLength();
    }

    @Deprecated
    public void clearAllTaskData() {
        this.pauseAll();
    }

    public boolean clear(int id, String targetFilePath) {
        this.pause(id);
        OkDownload.with().breakpointStore().remove(id);
        File targetFile = new File(targetFilePath);
        if (targetFile.exists()) {
            return targetFile.delete();
        }
        return true;
    }

    @Deprecated
    public byte getStatusIgnoreCompleted(int id) {
        byte status = this.getStatus(id, null);
        if (status == -3) {
            status = 0;
        }
        return status;
    }

    public byte getStatus(String url, String path) {
        File file = new File(path);
        StatusUtil.Status okDownloadStatus = StatusUtil.getStatus((String)url, (String)file.getParent(), (String)file.getName());
        return FileDownloadUtils.convertDownloadStatus(okDownloadStatus);
    }

    @Deprecated
    public byte getStatus(int id, String path) {
        BaseDownloadTask.IRunningTask task = FileDownloadList.getImpl().get(id);
        if (task == null) {
            return 0;
        }
        byte status = task.getOrigin().getStatus();
        return status;
    }

    public int replaceListener(String url, FileDownloadListener listener) {
        return this.replaceListener(url, FileDownloadUtils.getDefaultSaveFilePath(url), listener);
    }

    public int replaceListener(String url, String path, FileDownloadListener listener) {
        File file = new File(path);
        DownloadTask downloadTask = new DownloadTask.Builder(url, file).build();
        return this.replaceListener(downloadTask.getId(), listener);
    }

    public int replaceListener(int id, FileDownloadListener listener) {
        BaseDownloadTask.IRunningTask task = FileDownloadList.getImpl().get(id);
        if (task == null) {
            OkDownload.with().breakpointStore().remove(id);
            return 0;
        }
        DownloadTaskAdapter downloadTask = (DownloadTaskAdapter)task.getOrigin();
        downloadTask.replaceListener(listener);
        return downloadTask.getId();
    }

    public FileDownloadLine insureServiceBind() {
        return new FileDownloadLine();
    }

    @Deprecated
    public FileDownloadLineAsync insureServiceBindAsync() {
        return new FileDownloadLineAsync();
    }

    public void discardFileDownloadDatabase(Context context) {
        context.deleteDatabase(FILEDOWNLOADER_DATABASE_NAME);
    }

    private static final class HolderClass {
        private static final FileDownloader INSTANCE = new FileDownloader();

        private HolderClass() {
        }
    }
}

