/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.connection;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.okdownload.IRedirectHandler;
import com.liulishuo.okdownload.OkDownload;
import com.liulishuo.okdownload.RedirectUtil;
import com.liulishuo.okdownload.core.Util;
import com.liulishuo.okdownload.core.connection.DownloadConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;

public class DownloadConnectionAdapter
implements DownloadConnection,
DownloadConnection.Connected {
    @NonNull
    private final FileDownloadConnection fileDownloadConnection;
    @NonNull
    private final IRedirectHandler redirectHandler;
    @Nullable
    private DownloadConnectionAdapter redirectConnectAdapter;
    @NonNull
    private String requestMethod = "GET";
    private static final String TAG = "DownloadConnectionAdapter";

    public DownloadConnectionAdapter(@NonNull FileDownloadConnection fileDownloadConnection, @NonNull IRedirectHandler redirectHandler) {
        this.fileDownloadConnection = fileDownloadConnection;
        this.redirectHandler = redirectHandler;
    }

    public void addHeader(String name, String value) {
        this.fileDownloadConnection.addHeader(name, value);
    }

    public boolean setRequestMethod(@NonNull String method) throws ProtocolException {
        this.requestMethod = method;
        return this.fileDownloadConnection.setRequestMethod(method);
    }

    public DownloadConnection.Connected execute() throws IOException {
        Map<String, List<String>> headerProperties = this.getRequestProperties();
        this.fileDownloadConnection.execute();
        this.redirectHandler.handleRedirect((DownloadConnection)this, (DownloadConnection.Connected)this, headerProperties);
        return this;
    }

    public void release() {
        if (this.redirectConnectAdapter != null) {
            this.redirectConnectAdapter.release();
        } else {
            this.fileDownloadConnection.ending();
        }
    }

    public Map<String, List<String>> getRequestProperties() {
        return this.fileDownloadConnection.getRequestHeaderFields();
    }

    public String getRequestProperty(String key) {
        return "unknown";
    }

    public int getResponseCode() throws IOException {
        if (this.redirectConnectAdapter != null) {
            return this.redirectConnectAdapter.getResponseCode();
        }
        return this.fileDownloadConnection.getResponseCode();
    }

    public InputStream getInputStream() throws IOException {
        if (this.redirectConnectAdapter != null) {
            return this.redirectConnectAdapter.getInputStream();
        }
        return this.fileDownloadConnection.getInputStream();
    }

    @Nullable
    public Map<String, List<String>> getResponseHeaderFields() {
        if (this.redirectConnectAdapter != null) {
            return this.redirectConnectAdapter.getResponseHeaderFields();
        }
        return this.fileDownloadConnection.getResponseHeaderFields();
    }

    @Nullable
    public String getResponseHeaderField(String name) {
        if (this.redirectConnectAdapter != null) {
            return this.redirectConnectAdapter.getResponseHeaderField(name);
        }
        return this.fileDownloadConnection.getResponseHeaderField(name);
    }

    public String getRedirectLocation() {
        return this.redirectHandler.getRedirectLocation();
    }

    public static class Factory
    implements DownloadConnection.Factory {
        @NonNull
        private final FileDownloadHelper.ConnectionCreator creator;

        public Factory(@NonNull FileDownloadHelper.ConnectionCreator creator) {
            this.creator = creator;
        }

        public DownloadConnection create(String url) throws IOException {
            FileDownloadConnection fileDownloadConnection = this.creator.create(url);
            return new DownloadConnectionAdapter(fileDownloadConnection, new RedirectHandler());
        }
    }

    static final class RedirectHandler
    implements IRedirectHandler {
        String redirectLocation;

        RedirectHandler() {
        }

        public void handleRedirect(DownloadConnection originalConnection, DownloadConnection.Connected originalConnected, Map<String, List<String>> headerProperties) throws IOException {
            if (!(originalConnection instanceof DownloadConnectionAdapter)) {
                return;
            }
            String requestMethod = ((DownloadConnectionAdapter)originalConnection).requestMethod;
            int responseCode = originalConnected.getResponseCode();
            int redirectCount = 0;
            DownloadConnectionAdapter redirectConnectAdapter = null;
            DownloadConnection checkingDownloadConnection = originalConnection;
            while (RedirectUtil.isRedirect((int)responseCode)) {
                checkingDownloadConnection.release();
                if (++redirectCount > 10) {
                    throw new ProtocolException("Too many redirect requests: " + redirectCount);
                }
                this.redirectLocation = RedirectUtil.getRedirectedUrl((DownloadConnection.Connected)originalConnected, (int)responseCode);
                DownloadConnection redirectConnection = OkDownload.with().connectionFactory().create(this.redirectLocation);
                if (redirectConnection instanceof DownloadConnectionAdapter) {
                    Util.addRequestHeaderFields(headerProperties, (DownloadConnection)redirectConnection);
                    redirectConnection.setRequestMethod(requestMethod);
                    redirectConnectAdapter = (DownloadConnectionAdapter)redirectConnection;
                    Util.d((String)DownloadConnectionAdapter.TAG, (String)("connect redirect location with method: " + requestMethod));
                    redirectConnectAdapter.fileDownloadConnection.execute();
                    responseCode = redirectConnectAdapter.getResponseCode();
                    checkingDownloadConnection = redirectConnection;
                    continue;
                }
                this.redirectLocation = null;
                throw new InvalidClassException("The connection factory is customized, but now the factory creates a inconsistent connection: " + redirectConnection.getClass().getCanonicalName());
            }
            if (redirectConnectAdapter != null && this.redirectLocation != null) {
                DownloadConnectionAdapter originalAdapter = (DownloadConnectionAdapter)originalConnection;
                originalAdapter.redirectConnectAdapter = redirectConnectAdapter;
            }
        }

        @Nullable
        public String getRedirectLocation() {
            return this.redirectLocation;
        }
    }
}

