/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.exception;

import android.annotation.TargetApi;
import java.io.IOException;
import java.util.Locale;

public class FileDownloadOutOfSpaceException
extends IOException {
    private long freeSpaceBytes;
    private long requiredSpaceBytes;
    private long breakpointBytes;

    @TargetApi(value=9)
    public FileDownloadOutOfSpaceException(long freeSpaceBytes, long requiredSpaceBytes, long breakpointBytes, Throwable cause) {
        super(String.format(Locale.ENGLISH, "The file is too large to store, breakpoint in bytes:  %d, required space in bytes: %d, but free space in bytes: %d", breakpointBytes, requiredSpaceBytes, freeSpaceBytes), cause);
        this.init(freeSpaceBytes, requiredSpaceBytes, breakpointBytes);
    }

    public FileDownloadOutOfSpaceException(long freeSpaceBytes, long requiredSpaceBytes, long breakpointBytes) {
        super(String.format(Locale.ENGLISH, "The file is too large to store, breakpoint in bytes:  %d, required space in bytes: %d, but free space in bytes: %d", breakpointBytes, requiredSpaceBytes, freeSpaceBytes));
        this.init(freeSpaceBytes, requiredSpaceBytes, breakpointBytes);
    }

    private void init(long freeSpaceBytes, long requiredSpaceBytes, long breakpointBytes) {
        this.freeSpaceBytes = freeSpaceBytes;
        this.requiredSpaceBytes = requiredSpaceBytes;
        this.breakpointBytes = breakpointBytes;
    }

    public long getFreeSpaceBytes() {
        return this.freeSpaceBytes;
    }

    public long getRequiredSpaceBytes() {
        return this.requiredSpaceBytes;
    }

    public long getBreakpointBytes() {
        return this.breakpointBytes;
    }
}

