/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.progress;

import com.liulishuo.filedownloader.CompatListenerAssist;
import com.liulishuo.filedownloader.DownloadTaskAdapter;
import com.liulishuo.okdownload.SpeedCalculator;
import com.liulishuo.okdownload.core.Util;
import java.util.concurrent.atomic.AtomicLong;

public class ProgressAssist {
    static final int CALLBACK_SAFE_MIN_INTERVAL_BYTES = 1;
    static final int NO_ANY_PROGRESS_CALLBACK = -1;
    private static final long TOTAL_VALUE_IN_CHUNKED_RESOURCE = -1L;
    private static final String TAG = "ProgressAssist";
    private final int maxProgressCount;
    final AtomicLong sofarBytes;
    final AtomicLong incrementBytes;
    final SpeedCalculator speedCalculator;
    long callbackMinIntervalBytes = 1L;

    public ProgressAssist(int maxProgressCount) {
        this(maxProgressCount, new SpeedCalculator());
    }

    public ProgressAssist(int maxProgressCount, SpeedCalculator speedCalculator) {
        this.maxProgressCount = maxProgressCount;
        this.speedCalculator = speedCalculator;
        this.sofarBytes = new AtomicLong(0L);
        this.incrementBytes = new AtomicLong(0L);
    }

    public void calculateCallbackMinIntervalBytes(long contentLength) {
        long minIntervalBytes;
        this.callbackMinIntervalBytes = this.maxProgressCount <= 0 ? -1L : (contentLength == -1L ? 1L : ((minIntervalBytes = contentLength / (long)this.maxProgressCount) <= 0L ? 1L : minIntervalBytes));
        Util.d((String)TAG, (String)("contentLength: " + contentLength + " callbackMinIntervalBytes: " + this.callbackMinIntervalBytes));
    }

    public void onProgress(DownloadTaskAdapter downloadTaskAdapter, long increaseBytes, CompatListenerAssist.CompatListenerAssistCallback callback) {
        this.speedCalculator.downloading(increaseBytes);
        long sofar = this.sofarBytes.addAndGet(increaseBytes);
        if (this.canCallbackProgress(increaseBytes)) {
            callback.progress(downloadTaskAdapter, sofar, downloadTaskAdapter.getTotalBytesInLong());
        }
    }

    boolean canCallbackProgress(long increaseBytes) {
        if (this.callbackMinIntervalBytes == -1L) {
            return false;
        }
        long increment = this.incrementBytes.addAndGet(increaseBytes);
        if (increment >= this.callbackMinIntervalBytes) {
            this.incrementBytes.addAndGet(-this.callbackMinIntervalBytes);
            return true;
        }
        return false;
    }

    public long getSofarBytes() {
        return this.sofarBytes.get();
    }

    public void clearProgress() {
        Util.d((String)TAG, (String)("clear progress, sofar: " + this.sofarBytes.get() + " increment: " + this.incrementBytes.get()));
        this.sofarBytes.set(0L);
        this.incrementBytes.set(0L);
        this.speedCalculator.flush();
    }

    public void initSofarBytes(long soFarBytes) {
        Util.d((String)TAG, (String)("init sofar: " + soFarBytes));
        this.sofarBytes.set(soFarBytes);
    }

    public long getSpeed() {
        return this.speedCalculator.getBytesPerSecondAndFlush() / 1024L;
    }
}

