/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.retry;

import android.support.annotation.NonNull;
import com.liulishuo.okdownload.DownloadTask;
import java.util.concurrent.atomic.AtomicInteger;

public class RetryAssist {
    @NonNull
    final AtomicInteger retriedTimes;
    final int retryTimes;

    public RetryAssist(int retryTimes) {
        this.retryTimes = retryTimes;
        this.retriedTimes = new AtomicInteger(0);
    }

    public void doRetry(@NonNull DownloadTask task) {
        int retryingTime = this.retriedTimes.incrementAndGet();
        if (retryingTime > this.retryTimes) {
            throw new RuntimeException("retry has exceeded limit");
        }
        task.enqueue(task.getListener());
    }

    public boolean canRetry() {
        return this.retriedTimes.get() < this.retryTimes;
    }

    public int getRetriedTimes() {
        return this.retriedTimes.get();
    }
}

