/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.content.Context;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.connection.DownloadConnectionAdapter;
import com.liulishuo.filedownloader.services.ForegroundServiceConfig;
import com.liulishuo.filedownloader.stream.DownloadOutputStreamAdapter;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.okdownload.OkDownload;
import com.liulishuo.okdownload.core.connection.DownloadConnection;
import com.liulishuo.okdownload.core.file.DownloadOutputStream;

public class DownloadMgrInitialParams {

    public static class InitCustomMaker {
        FileDownloadHelper.OutputStreamCreator mOutputStreamCreator;
        FileDownloadHelper.ConnectionCreator mConnectionCreator;
        final Context mContext;

        public InitCustomMaker(Context context) {
            this.mContext = context;
        }

        public InitCustomMaker idGenerator(FileDownloadHelper.IdGenerator idGenerator) {
            return this;
        }

        public InitCustomMaker connectionCountAdapter(FileDownloadHelper.ConnectionCountAdapter adapter) {
            return this;
        }

        public InitCustomMaker database(FileDownloadHelper.DatabaseCustomMaker maker) {
            return this;
        }

        public InitCustomMaker maxNetworkThreadCount(int maxNetworkThreadCount) {
            return this;
        }

        public InitCustomMaker outputStreamCreator(FileDownloadHelper.OutputStreamCreator creator) {
            this.mOutputStreamCreator = creator;
            return this;
        }

        public InitCustomMaker connectionCreator(FileDownloadHelper.ConnectionCreator creator) {
            this.mConnectionCreator = creator;
            return this;
        }

        public InitCustomMaker foregroundServiceConfig(ForegroundServiceConfig config) {
            return this;
        }

        public void commit() {
            FileDownloader.setup(this.mContext);
            OkDownload.Builder builder = FileDownloader.okDownloadBuilder(this.mContext, null);
            if (this.mOutputStreamCreator != null) {
                if (builder == null) {
                    builder = new OkDownload.Builder(this.mContext);
                }
                builder.outputStreamFactory((DownloadOutputStream.Factory)new DownloadOutputStreamAdapter.Factory(this.mOutputStreamCreator));
            }
            if (this.mConnectionCreator != null) {
                if (builder == null) {
                    builder = new OkDownload.Builder(this.mContext);
                }
                builder.connectionFactory((DownloadConnection.Factory)new DownloadConnectionAdapter.Factory(this.mConnectionCreator));
            }
            if (builder != null) {
                OkDownload.setSingletonInstance((OkDownload)builder.build());
            }
        }
    }
}

