/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.stream;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.okdownload.core.file.DownloadOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DownloadOutputStreamAdapter
implements DownloadOutputStream {
    @NonNull
    private final FileDownloadOutputStream fileDownloadOutputStream;

    public DownloadOutputStreamAdapter(@NonNull FileDownloadOutputStream outputStream) {
        this.fileDownloadOutputStream = outputStream;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fileDownloadOutputStream.write(b, off, len);
    }

    public void close() throws IOException {
        this.fileDownloadOutputStream.close();
    }

    public void flushAndSync() throws IOException {
        this.fileDownloadOutputStream.flushAndSync();
    }

    public void seek(long offset) throws IOException {
        try {
            this.fileDownloadOutputStream.seek(offset);
        }
        catch (IllegalAccessException e) {
            throw new IOException("illegal access", e);
        }
    }

    public void setLength(long newLength) throws IOException {
        try {
            this.fileDownloadOutputStream.setLength(newLength);
        }
        catch (IllegalAccessException e) {
            throw new IOException("illegal access", e);
        }
    }

    public static class Factory
    implements DownloadOutputStream.Factory {
        @NonNull
        private final FileDownloadHelper.OutputStreamCreator creator;

        public Factory(@NonNull FileDownloadHelper.OutputStreamCreator creator) {
            this.creator = creator;
        }

        public DownloadOutputStream create(Context context, File file, int flushBufferSize) throws FileNotFoundException {
            if (file == null) {
                throw new FileNotFoundException("file is null");
            }
            try {
                return new DownloadOutputStreamAdapter(this.creator.create(file));
            }
            catch (IOException e) {
                throw new FileNotFoundException("create filedownloader output stream error: " + e.getMessage());
            }
        }

        public DownloadOutputStream create(Context context, Uri uri, int flushBufferSize) throws FileNotFoundException {
            if (uri == null) {
                throw new FileNotFoundException("file is null");
            }
            if ("file".equals(uri.getScheme())) {
                String filePath = uri.getPath();
                if (filePath == null) {
                    throw new FileNotFoundException("file path is null");
                }
                return this.create(context, new File(filePath), flushBufferSize);
            }
            throw new FileNotFoundException("filedownloader supports file schema only");
        }

        public boolean supportSeek() {
            return true;
        }
    }
}

