/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.support.annotation.NonNull;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadTaskAdapter;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.liulishuo.okdownload.DownloadListener;
import com.liulishuo.okdownload.DownloadSerialQueue;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.UnifiedListenerManager;
import java.util.ArrayList;
import java.util.List;

public class FileDownloadSerialQueue {
    final DownloadSerialQueue serialQueue;
    final UnifiedListenerManager listenerManager;

    public FileDownloadSerialQueue() {
        this(new DownloadSerialQueue(), new UnifiedListenerManager());
    }

    public FileDownloadSerialQueue(@NonNull DownloadSerialQueue serialQueue, @NonNull UnifiedListenerManager listenerManager) {
        this.serialQueue = serialQueue;
        this.listenerManager = listenerManager;
        this.serialQueue.setListener(this.listenerManager.getHostListener());
    }

    public void enqueue(BaseDownloadTask task) {
        DownloadTaskAdapter downloadTaskAdapter = (DownloadTaskAdapter)task;
        downloadTaskAdapter.insureAssembleDownloadTask();
        FileDownloadList.getImpl().addIndependentTask(downloadTaskAdapter);
        this.serialQueue.enqueue(downloadTaskAdapter.getDownloadTask());
        this.listenerManager.addAutoRemoveListenersWhenTaskEnd(downloadTaskAdapter.getId());
        this.listenerManager.attachListener(downloadTaskAdapter.getDownloadTask(), (DownloadListener)downloadTaskAdapter.getCompatListener());
    }

    public void pause() {
        this.serialQueue.pause();
    }

    public void resume() {
        this.serialQueue.resume();
    }

    public int getWorkingTaskId() {
        return this.serialQueue.getWorkingTaskId();
    }

    public int getWaitingTaskCount() {
        return this.serialQueue.getWaitingTaskCount();
    }

    public List<BaseDownloadTask> shutdown() {
        DownloadTask[] tasks = this.serialQueue.shutdown();
        ArrayList<BaseDownloadTask> notRunningTasks = new ArrayList<BaseDownloadTask>();
        for (DownloadTask task : tasks) {
            DownloadTaskAdapter notRunningTask = FileDownloadUtils.findDownloadTaskAdapter(task);
            if (notRunningTask == null) continue;
            notRunningTasks.add(notRunningTask);
            FileDownloadList.getImpl().remove(notRunningTask);
        }
        return notRunningTasks;
    }
}

