/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liulishuo.filedownloader.DownloadTaskAdapter;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.StatusUtil;
import com.liulishuo.okdownload.core.Util;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileDownloadUtils {
    private static String defaultSaveRootPath;
    private static final String TAG = "FileDownloadUtils";
    private static final String FILEDOWNLOADER_PREFIX = "FileDownloader";
    private static final Pattern CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN;
    private static final Pattern CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN;

    public static String getDefaultSaveRootPath() {
        if (!TextUtils.isEmpty((CharSequence)defaultSaveRootPath)) {
            return defaultSaveRootPath;
        }
        if (FileDownloadHelper.getAppContext().getExternalCacheDir() == null) {
            return Environment.getDownloadCacheDirectory().getAbsolutePath();
        }
        return FileDownloadHelper.getAppContext().getExternalCacheDir().getAbsolutePath();
    }

    public static void setDefaultSaveRootPath(String path) {
        defaultSaveRootPath = path;
    }

    public static String getDefaultSaveFilePath(String url) {
        return FileDownloadUtils.generateFilePath(FileDownloadUtils.getDefaultSaveRootPath(), FileDownloadUtils.generateFileName(url));
    }

    public static String generateFileName(String url) {
        return FileDownloadUtils.md5(url);
    }

    public static String generateFilePath(String directory, String filename) {
        if (filename == null) {
            throw new IllegalStateException("can't generate real path, the file name is null");
        }
        if (directory == null) {
            throw new IllegalStateException("can't generate real path, the directory is null");
        }
        return String.format("%s%s%s", directory, File.separator, filename);
    }

    public static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append(0);
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    @Nullable
    public static DownloadTaskAdapter findDownloadTaskAdapter(DownloadTask downloadTask) {
        if (downloadTask == null) {
            Util.w((String)TAG, (String)"download task is null when find DownloadTaskAdapter");
            return null;
        }
        Object o = downloadTask.getTag(Integer.MIN_VALUE);
        if (o == null) {
            Util.w((String)TAG, (String)"no tag with DownloadTaskAdapter.KEY_TASK_ADAPTER");
            return null;
        }
        if (o instanceof DownloadTaskAdapter) {
            return (DownloadTaskAdapter)o;
        }
        Util.w((String)TAG, (String)"download task's tag is not DownloadTaskAdapter");
        return null;
    }

    public static byte convertDownloadStatus(StatusUtil.Status status) {
        switch (status) {
            case COMPLETED: {
                return -3;
            }
            case IDLE: {
                return -2;
            }
            case PENDING: {
                return 1;
            }
            case RUNNING: {
                return 3;
            }
        }
        return 0;
    }

    @Deprecated
    public static String getTempPath(String targetPath) {
        return String.format(Locale.ENGLISH, "%s.temp", targetPath);
    }

    @Deprecated
    public static String getThreadPoolName(String name) {
        return "FileDownloader-" + name;
    }

    @Deprecated
    public static void setMinProgressStep(int minProgressStep) throws IllegalAccessException {
    }

    @Deprecated
    public static void setMinProgressTime(long minProgressTime) throws IllegalAccessException {
    }

    @Deprecated
    public static int getMinProgressStep() {
        return 0;
    }

    @Deprecated
    public static long getMinProgressTime() {
        return 0L;
    }

    @Deprecated
    public static boolean isFilenameValid(String filename) {
        return true;
    }

    @Deprecated
    public static int generateId(String url, String path) {
        return new DownloadTask.Builder(url, new File(path)).build().getId();
    }

    @Deprecated
    public static int generateId(String url, String path, boolean pathAsDirectory) {
        if (pathAsDirectory) {
            return new DownloadTask.Builder(url, path, null).build().getId();
        }
        return FileDownloadUtils.generateId(url, path);
    }

    public static String getStack() {
        return FileDownloadUtils.getStack(true);
    }

    public static String getStack(boolean printLine) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return FileDownloadUtils.getStack(stackTrace, printLine);
    }

    public static String getStack(StackTraceElement[] stackTrace, boolean printLine) {
        if (stackTrace == null || stackTrace.length < 4) {
            return "";
        }
        StringBuilder t = new StringBuilder();
        for (int i = 3; i < stackTrace.length; ++i) {
            if (!stackTrace[i].getClassName().contains("com.liulishuo.filedownloader")) continue;
            t.append('[');
            t.append(stackTrace[i].getClassName().substring("com.liulishuo.filedownloader".length()));
            t.append(':');
            t.append(stackTrace[i].getMethodName());
            if (printLine) {
                t.append('(').append(stackTrace[i].getLineNumber()).append(")]");
                continue;
            }
            t.append(']');
        }
        return t.toString();
    }

    @Deprecated
    public static boolean isDownloaderProcess(Context context) {
        return false;
    }

    public static String[] convertHeaderString(String nameAndValuesString) {
        String[] lineString = nameAndValuesString.split("\n");
        String[] namesAndValues = new String[lineString.length * 2];
        for (int i = 0; i < lineString.length; ++i) {
            String[] nameAndValue = lineString[i].split(": ");
            namesAndValues[i * 2] = nameAndValue[0];
            namesAndValues[i * 2 + 1] = nameAndValue[1];
        }
        return namesAndValues;
    }

    public static long getFreeSpaceBytes(String path) {
        StatFs statFs = new StatFs(path);
        long freeSpaceBytes = Build.VERSION.SDK_INT >= 18 ? statFs.getAvailableBytes() : (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
        return freeSpaceBytes;
    }

    public static String formatString(String msg, Object ... args) {
        return String.format(Locale.ENGLISH, msg, args);
    }

    @Deprecated
    public static long parseContentRangeFoInstanceLength(String contentRange) {
        return -1L;
    }

    public static String parseContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return null;
        }
        try {
            Matcher m = CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                String charset = m.group(1);
                String encodeFileName = m.group(2);
                return URLDecoder.decode(encodeFileName, charset);
            }
            m = CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (UnsupportedEncodingException | IllegalStateException exception) {
            // empty catch block
        }
        return null;
    }

    public static String getTargetFilePath(String path, boolean pathAsDirectory, String filename) {
        if (path == null) {
            return null;
        }
        if (pathAsDirectory) {
            if (filename == null) {
                return null;
            }
            return FileDownloadUtils.generateFilePath(path, filename);
        }
        return path;
    }

    public static String getParent(String path) {
        int index;
        int length = path.length();
        int firstInPath = 0;
        if (File.separatorChar == '\\' && length > 2 && path.charAt(1) == ':') {
            firstInPath = 2;
        }
        if ((index = path.lastIndexOf(File.separatorChar)) == -1 && firstInPath > 0) {
            index = 2;
        }
        if (index == -1 || path.charAt(length - 1) == File.separatorChar) {
            return null;
        }
        if (path.indexOf(File.separatorChar) == index && path.charAt(firstInPath) == File.separatorChar) {
            return path.substring(0, index + 1);
        }
        return path.substring(0, index);
    }

    @Deprecated
    public static boolean isNetworkNotOnWifiType() {
        return false;
    }

    public static boolean checkPermission(String permission) {
        int perm = FileDownloadHelper.getAppContext().checkCallingOrSelfPermission(permission);
        return perm == 0;
    }

    public static void deleteTaskFiles(String targetFilepath, String tempFilePath) {
        FileDownloadUtils.deleteTempFile(tempFilePath);
        FileDownloadUtils.deleteTargetFile(targetFilepath);
    }

    public static void deleteTempFile(String tempFilePath) {
        File tempFile;
        if (tempFilePath != null && (tempFile = new File(tempFilePath)).exists()) {
            tempFile.delete();
        }
    }

    public static void deleteTargetFile(String targetFilePath) {
        File targetFile;
        if (targetFilePath != null && (targetFile = new File(targetFilePath)).exists()) {
            targetFile.delete();
        }
    }

    static {
        CONTENT_DISPOSITION_WITH_ASTERISK_PATTERN = Pattern.compile("attachment;\\s*filename\\*\\s*=\\s*\"*([^\"]*)'\\S*'([^\"]*)\"*");
        CONTENT_DISPOSITION_WITHOUT_ASTERISK_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"*([^\"\\n]*)\"*");
    }
}

