/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.okdownload.core.connection;

import android.support.annotation.NonNull;
import com.liulishuo.okdownload.core.connection.DownloadConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DownloadOkHttp3Connection
implements DownloadConnection,
DownloadConnection.Connected {
    @NonNull
    final OkHttpClient client;
    @NonNull
    private final Request.Builder requestBuilder;
    private Request request;
    Response response;

    DownloadOkHttp3Connection(@NonNull OkHttpClient client, @NonNull Request.Builder requestBuilder) {
        this.client = client;
        this.requestBuilder = requestBuilder;
    }

    DownloadOkHttp3Connection(@NonNull OkHttpClient client, @NonNull String url) {
        this(client, new Request.Builder().url(url));
    }

    public void addHeader(String name, String value) {
        this.requestBuilder.addHeader(name, value);
    }

    public DownloadConnection.Connected execute() throws IOException {
        this.request = this.requestBuilder.build();
        this.response = this.client.newCall(this.request).execute();
        return this;
    }

    public void release() {
        this.request = null;
        if (this.response != null) {
            this.response.close();
        }
        this.response = null;
    }

    public Map<String, List<String>> getRequestProperties() {
        if (this.request != null) {
            return this.request.headers().toMultimap();
        }
        return this.requestBuilder.build().headers().toMultimap();
    }

    public String getRequestProperty(String key) {
        if (this.request != null) {
            return this.request.header(key);
        }
        return this.requestBuilder.build().header(key);
    }

    public int getResponseCode() throws IOException {
        if (this.response == null) {
            throw new IOException("Please invoke execute first!");
        }
        return this.response.code();
    }

    public InputStream getInputStream() throws IOException {
        if (this.response == null) {
            throw new IOException("Please invoke execute first!");
        }
        ResponseBody body = this.response.body();
        if (body == null) {
            throw new IOException("no body found on response!");
        }
        return body.byteStream();
    }

    public boolean setRequestMethod(@NonNull String method) throws ProtocolException {
        this.requestBuilder.method(method, null);
        return true;
    }

    public Map<String, List<String>> getResponseHeaderFields() {
        return this.response == null ? null : this.response.headers().toMultimap();
    }

    public String getResponseHeaderField(String name) {
        return this.response == null ? null : this.response.header(name);
    }

    public static class Factory
    implements DownloadConnection.Factory {
        private OkHttpClient.Builder builder;
        private volatile OkHttpClient client;

        public Factory setBuilder(@NonNull OkHttpClient.Builder builder) {
            this.builder = builder;
            return this;
        }

        @NonNull
        public OkHttpClient.Builder builder() {
            if (this.builder == null) {
                this.builder = new OkHttpClient.Builder();
            }
            return this.builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public DownloadConnection create(String url) throws IOException {
            if (this.client != null) return new DownloadOkHttp3Connection(this.client, url);
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (this.client != null) return new DownloadOkHttp3Connection(this.client, url);
                this.client = this.builder != null ? this.builder.build() : new OkHttpClient();
                this.builder = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new DownloadOkHttp3Connection(this.client, url);
            }
        }
    }
}

