/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.okdownload.core.breakpoint;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.core.Util;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.breakpoint.BreakpointSQLiteHelper;
import com.liulishuo.okdownload.core.breakpoint.BreakpointStoreOnCache;
import com.liulishuo.okdownload.core.breakpoint.DownloadStore;
import com.liulishuo.okdownload.core.breakpoint.RemitStoreOnSQLite;
import com.liulishuo.okdownload.core.cause.EndCause;
import java.io.IOException;

public class BreakpointStoreOnSQLite
implements DownloadStore {
    private static final String TAG = "BreakpointStoreOnSQLite";
    protected final BreakpointSQLiteHelper helper;
    protected final BreakpointStoreOnCache onCache;

    BreakpointStoreOnSQLite(BreakpointSQLiteHelper helper, BreakpointStoreOnCache onCache) {
        this.helper = helper;
        this.onCache = onCache;
    }

    public BreakpointStoreOnSQLite(Context context) {
        this.helper = new BreakpointSQLiteHelper(context.getApplicationContext());
        this.onCache = new BreakpointStoreOnCache(this.helper.loadToCache(), this.helper.loadResponseFilenameToMap());
    }

    @Nullable
    public BreakpointInfo get(int id) {
        return this.onCache.get(id);
    }

    @NonNull
    public BreakpointInfo createAndInsert(@NonNull DownloadTask task) throws IOException {
        BreakpointInfo info = this.onCache.createAndInsert(task);
        this.helper.insert(info);
        return info;
    }

    public void onTaskStart(int id) {
        this.onCache.onTaskStart(id);
    }

    public void onSyncToFilesystemSuccess(@NonNull BreakpointInfo info, int blockIndex, long increaseLength) throws IOException {
        this.onCache.onSyncToFilesystemSuccess(info, blockIndex, increaseLength);
        long newCurrentOffset = info.getBlock(blockIndex).getCurrentOffset();
        this.helper.updateBlockIncrease(info, blockIndex, newCurrentOffset);
    }

    public boolean update(@NonNull BreakpointInfo breakpointInfo) throws IOException {
        boolean result = this.onCache.update(breakpointInfo);
        this.helper.updateInfo(breakpointInfo);
        String filename = breakpointInfo.getFilename();
        Util.d((String)TAG, (String)("update " + breakpointInfo));
        if (breakpointInfo.isTaskOnlyProvidedParentPath() && filename != null) {
            this.helper.updateFilename(breakpointInfo.getUrl(), filename);
        }
        return result;
    }

    public void onTaskEnd(int id, @NonNull EndCause cause, @Nullable Exception exception) {
        this.onCache.onTaskEnd(id, cause, exception);
        if (cause == EndCause.COMPLETED) {
            this.helper.removeInfo(id);
        }
    }

    @Nullable
    public BreakpointInfo getAfterCompleted(int id) {
        return null;
    }

    public void remove(int id) {
        this.onCache.remove(id);
        this.helper.removeInfo(id);
    }

    public int findOrCreateId(@NonNull DownloadTask task) {
        return this.onCache.findOrCreateId(task);
    }

    @Nullable
    public BreakpointInfo findAnotherInfoFromCompare(@NonNull DownloadTask task, @NonNull BreakpointInfo ignored) {
        return this.onCache.findAnotherInfoFromCompare(task, ignored);
    }

    public boolean isOnlyMemoryCache() {
        return false;
    }

    @Nullable
    public String getResponseFilename(String url) {
        return this.onCache.getResponseFilename(url);
    }

    void close() {
        this.helper.close();
    }

    @NonNull
    public DownloadStore createRemitSelf() {
        return new RemitStoreOnSQLite(this);
    }
}

