/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.okdownload.core.breakpoint;

import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.OkDownload;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.breakpoint.BreakpointSQLiteHelper;
import com.liulishuo.okdownload.core.breakpoint.BreakpointStore;
import com.liulishuo.okdownload.core.breakpoint.BreakpointStoreOnSQLite;
import com.liulishuo.okdownload.core.breakpoint.DownloadStore;
import com.liulishuo.okdownload.core.breakpoint.RemitSyncExecutor;
import com.liulishuo.okdownload.core.breakpoint.RemitSyncToDBHelper;
import com.liulishuo.okdownload.core.cause.EndCause;
import java.io.IOException;
import java.util.List;

public class RemitStoreOnSQLite
implements RemitSyncExecutor.RemitAgent,
DownloadStore {
    private static final String TAG = "RemitStoreOnSQLite";
    @NonNull
    private final RemitSyncToDBHelper remitHelper;
    @NonNull
    private final BreakpointStoreOnSQLite onSQLiteWrapper;
    @NonNull
    private final BreakpointSQLiteHelper sqLiteHelper;
    @NonNull
    private final DownloadStore sqliteCache;

    RemitStoreOnSQLite(@NonNull BreakpointStoreOnSQLite sqlite) {
        this.remitHelper = new RemitSyncToDBHelper(this);
        this.onSQLiteWrapper = sqlite;
        this.sqliteCache = this.onSQLiteWrapper.onCache;
        this.sqLiteHelper = this.onSQLiteWrapper.helper;
    }

    RemitStoreOnSQLite(@NonNull RemitSyncToDBHelper helper, @NonNull BreakpointStoreOnSQLite sqlite, @NonNull DownloadStore sqliteCache, @NonNull BreakpointSQLiteHelper sqLiteHelper) {
        this.remitHelper = helper;
        this.onSQLiteWrapper = sqlite;
        this.sqliteCache = sqliteCache;
        this.sqLiteHelper = sqLiteHelper;
    }

    @Nullable
    public BreakpointInfo get(int id) {
        return this.onSQLiteWrapper.get(id);
    }

    @NonNull
    public BreakpointInfo createAndInsert(@NonNull DownloadTask task) throws IOException {
        if (this.remitHelper.isNotFreeToDatabase(task.getId())) {
            return this.sqliteCache.createAndInsert(task);
        }
        return this.onSQLiteWrapper.createAndInsert(task);
    }

    public void onTaskStart(int id) {
        this.onSQLiteWrapper.onTaskStart(id);
        this.remitHelper.onTaskStart(id);
    }

    public void onSyncToFilesystemSuccess(@NonNull BreakpointInfo info, int blockIndex, long increaseLength) throws IOException {
        if (this.remitHelper.isNotFreeToDatabase(info.getId())) {
            this.sqliteCache.onSyncToFilesystemSuccess(info, blockIndex, increaseLength);
            return;
        }
        this.onSQLiteWrapper.onSyncToFilesystemSuccess(info, blockIndex, increaseLength);
    }

    public boolean update(@NonNull BreakpointInfo info) throws IOException {
        if (this.remitHelper.isNotFreeToDatabase(info.getId())) {
            return this.sqliteCache.update(info);
        }
        return this.onSQLiteWrapper.update(info);
    }

    public void onTaskEnd(int id, @NonNull EndCause cause, @Nullable Exception exception) {
        this.sqliteCache.onTaskEnd(id, cause, exception);
        if (cause == EndCause.COMPLETED) {
            this.remitHelper.discard(id);
        } else {
            this.remitHelper.endAndEnsureToDB(id);
        }
    }

    @Nullable
    public BreakpointInfo getAfterCompleted(int id) {
        return null;
    }

    public void remove(int id) {
        this.sqliteCache.remove(id);
        this.remitHelper.discard(id);
    }

    public int findOrCreateId(@NonNull DownloadTask task) {
        return this.onSQLiteWrapper.findOrCreateId(task);
    }

    @Nullable
    public BreakpointInfo findAnotherInfoFromCompare(@NonNull DownloadTask task, @NonNull BreakpointInfo ignored) {
        return this.onSQLiteWrapper.findAnotherInfoFromCompare(task, ignored);
    }

    public boolean isOnlyMemoryCache() {
        return false;
    }

    @Nullable
    public String getResponseFilename(String url) {
        return this.onSQLiteWrapper.getResponseFilename(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncCacheToDB(List<Integer> idList) throws IOException {
        SQLiteDatabase database = this.sqLiteHelper.getWritableDatabase();
        database.beginTransaction();
        try {
            for (Integer id : idList) {
                this.syncCacheToDB(id);
            }
            database.setTransactionSuccessful();
        }
        finally {
            database.endTransaction();
        }
    }

    @Override
    public void syncCacheToDB(int id) throws IOException {
        this.sqLiteHelper.removeInfo(id);
        BreakpointInfo info = this.sqliteCache.get(id);
        if (info == null || info.getFilename() == null || info.getTotalOffset() <= 0L) {
            return;
        }
        this.sqLiteHelper.insert(info);
    }

    @Override
    public void removeInfo(int id) {
        this.sqLiteHelper.removeInfo(id);
    }

    public static void setRemitToDBDelayMillis(int delayMillis) {
        BreakpointStore store = OkDownload.with().breakpointStore();
        if (!(store instanceof RemitStoreOnSQLite)) {
            throw new IllegalStateException("The current store is " + store + " not RemitStoreOnSQLite!");
        }
        delayMillis = Math.max(0, delayMillis);
        ((RemitStoreOnSQLite)store).remitHelper.delayMillis = delayMillis;
    }
}

