/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.okdownload.core.breakpoint;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liulishuo.okdownload.core.Util;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemitSyncExecutor
implements Handler.Callback {
    private static final String TAG = "RemitSyncExecutor";
    static final int WHAT_SYNC_BUNCH_ID = 0;
    static final int WHAT_REMOVE_FREE_BUNCH_ID = -1;
    static final int WHAT_REMOVE_FREE_ID = -2;
    static final int WHAT_REMOVE_INFO = -3;
    @NonNull
    private final Handler handler;
    @NonNull
    private final Set<Integer> freeToDBIdList;
    @NonNull
    private final RemitAgent agent;

    RemitSyncExecutor(@NonNull RemitAgent agent) {
        this.agent = agent;
        this.freeToDBIdList = new HashSet<Integer>();
        HandlerThread thread = new HandlerThread("OkDownload RemitHandoverToDB");
        thread.start();
        this.handler = new Handler(thread.getLooper(), (Handler.Callback)this);
    }

    RemitSyncExecutor(@NonNull RemitAgent agent, @Nullable Handler handler, @NonNull Set<Integer> freeToDBIdList) {
        this.agent = agent;
        this.handler = handler;
        this.freeToDBIdList = freeToDBIdList;
    }

    void shutdown() {
        this.handler.getLooper().quit();
    }

    boolean isFreeToDatabase(int id) {
        return this.freeToDBIdList.contains(id);
    }

    public void postSyncInfoDelay(int id, long delayMillis) {
        this.handler.sendEmptyMessageDelayed(id, delayMillis);
    }

    public void postSync(int id) {
        this.handler.sendEmptyMessage(id);
    }

    public void postSync(List<Integer> idList) {
        Message message = this.handler.obtainMessage(0);
        message.obj = idList;
        this.handler.sendMessage(message);
    }

    public void postRemoveInfo(int id) {
        Message message = this.handler.obtainMessage(-3);
        message.arg1 = id;
        this.handler.sendMessage(message);
    }

    public void postRemoveFreeIds(List<Integer> idList) {
        Message message = this.handler.obtainMessage(-1);
        message.obj = idList;
        this.handler.sendMessage(message);
    }

    public void postRemoveFreeId(int id) {
        Message message = this.handler.obtainMessage(-2);
        message.arg1 = id;
        this.handler.sendMessage(message);
    }

    void removePostWithId(int id) {
        this.handler.removeMessages(id);
    }

    void removePostWithIds(int[] ids) {
        for (int id : ids) {
            this.handler.removeMessages(id);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case -3: {
                int id = msg.arg1;
                this.freeToDBIdList.remove(id);
                this.agent.removeInfo(id);
                Util.d((String)TAG, (String)("remove info " + id));
                break;
            }
            case -1: {
                List idList = (List)msg.obj;
                this.freeToDBIdList.removeAll(idList);
                Util.d((String)TAG, (String)("remove free bunch ids " + idList));
                break;
            }
            case -2: {
                int id = msg.arg1;
                this.freeToDBIdList.remove(id);
                Util.d((String)TAG, (String)("remove free bunch id " + id));
                break;
            }
            case 0: {
                List idList = (List)msg.obj;
                try {
                    this.agent.syncCacheToDB(idList);
                    this.freeToDBIdList.addAll(idList);
                    Util.d((String)TAG, (String)("sync bunch info with ids: " + idList));
                }
                catch (IOException e) {
                    Util.w((String)TAG, (String)("sync info to db failed for ids: " + idList));
                }
                break;
            }
            default: {
                int id = msg.what;
                try {
                    this.agent.syncCacheToDB(id);
                    this.freeToDBIdList.add(id);
                    Util.d((String)TAG, (String)("sync info with id: " + id));
                    break;
                }
                catch (IOException e) {
                    Util.w((String)TAG, (String)("sync cache to db failed for id: " + id));
                }
            }
        }
        return true;
    }

    static interface RemitAgent {
        public void syncCacheToDB(List<Integer> var1) throws IOException;

        public void syncCacheToDB(int var1) throws IOException;

        public void removeInfo(int var1);
    }
}

