/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.okdownload.core.breakpoint;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.liulishuo.okdownload.core.breakpoint.BlockInfo;
import com.liulishuo.okdownload.core.breakpoint.BlockInfoRow;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfoRow;
import com.liulishuo.okdownload.core.exception.SQLiteException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BreakpointSQLiteHelper
extends SQLiteOpenHelper {
    private static final String NAME = "okdownload-breakpoint.db";
    private static final int VERSION = 3;
    private static final String RESPONSE_FILENAME_TABLE_NAME = "okdownloadResponseFilename";
    private static final String BREAKPOINT_TABLE_NAME = "breakpoint";
    private static final String BLOCK_TABLE_NAME = "block";
    static final String TASK_FILE_DIRTY_TABLE_NAME = "taskFileDirty";

    public BreakpointSQLiteHelper(Context context) {
        super(context, NAME, null, 3);
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setWriteAheadLoggingEnabled(true);
        } else {
            db.enableWriteAheadLogging();
        }
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS breakpoint( id INTEGER PRIMARY KEY, url VARCHAR NOT NULL, etag VARCHAR, parent_path VARCHAR NOT NULL, filename VARCHAR, task_only_parent_path TINYINT(1) DEFAULT 0, chunked TINYINT(1) DEFAULT 0)");
        db.execSQL("CREATE TABLE IF NOT EXISTS block( id INTEGER PRIMARY KEY AUTOINCREMENT, breakpoint_id INTEGER, block_index INTEGER, start_offset INTEGER, content_length INTEGER, current_offset INTEGER)");
        db.execSQL("CREATE TABLE IF NOT EXISTS okdownloadResponseFilename( url VARCHAR NOT NULL PRIMARY KEY, filename VARCHAR NOT NULL)");
        db.execSQL("CREATE TABLE IF NOT EXISTS taskFileDirty( id INTEGER PRIMARY KEY)");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion == 1 && newVersion == 2) {
            db.execSQL("CREATE TABLE IF NOT EXISTS okdownloadResponseFilename( url VARCHAR NOT NULL PRIMARY KEY, filename VARCHAR NOT NULL)");
        }
        if (oldVersion <= 2) {
            db.execSQL("CREATE TABLE IF NOT EXISTS taskFileDirty( id INTEGER PRIMARY KEY)");
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public void markFileDirty(int id) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues(1);
        values.put("id", Integer.valueOf(id));
        db.insert(TASK_FILE_DIRTY_TABLE_NAME, null, values);
    }

    public void markFileClear(int id) {
        this.getWritableDatabase().delete(TASK_FILE_DIRTY_TABLE_NAME, "id = ?", new String[]{String.valueOf(id)});
    }

    public List<Integer> loadDirtyFileList() {
        ArrayList<Integer> dirtyFileList = new ArrayList<Integer>();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("SELECT * FROM taskFileDirty", null);
            while (cursor.moveToNext()) {
                dirtyFileList.add(cursor.getInt(cursor.getColumnIndex("id")));
            }
        }
        return dirtyFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<BreakpointInfo> loadToCache() {
        Cursor breakpointCursor = null;
        Cursor blockCursor = null;
        SQLiteDatabase db = this.getWritableDatabase();
        ArrayList<BreakpointInfoRow> breakpointInfoRows = new ArrayList<BreakpointInfoRow>();
        ArrayList<BlockInfoRow> blockInfoRows = new ArrayList<BlockInfoRow>();
        try {
            breakpointCursor = db.rawQuery("SELECT * FROM breakpoint", null);
            while (breakpointCursor.moveToNext()) {
                breakpointInfoRows.add(new BreakpointInfoRow(breakpointCursor));
            }
            blockCursor = db.rawQuery("SELECT * FROM block", null);
            while (blockCursor.moveToNext()) {
                blockInfoRows.add(new BlockInfoRow(blockCursor));
            }
        }
        finally {
            if (breakpointCursor != null) {
                breakpointCursor.close();
            }
            if (blockCursor != null) {
                blockCursor.close();
            }
        }
        SparseArray breakpointInfoMap = new SparseArray();
        for (BreakpointInfoRow infoRow : breakpointInfoRows) {
            BreakpointInfo info = infoRow.toInfo();
            Iterator blockIt = blockInfoRows.iterator();
            while (blockIt.hasNext()) {
                BlockInfoRow blockInfoRow = (BlockInfoRow)blockIt.next();
                if (blockInfoRow.getBreakpointId() != info.id) continue;
                info.addBlock(blockInfoRow.toInfo());
                blockIt.remove();
            }
            breakpointInfoMap.put(info.id, (Object)info);
        }
        return breakpointInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> loadResponseFilenameToMap() {
        Cursor cursor = null;
        SQLiteDatabase db = this.getWritableDatabase();
        HashMap<String, String> urlFilenameMap = new HashMap<String, String>();
        try {
            cursor = db.rawQuery("SELECT * FROM okdownloadResponseFilename", null);
            while (cursor.moveToNext()) {
                String url = cursor.getString(cursor.getColumnIndex("url"));
                String filename = cursor.getString(cursor.getColumnIndex("filename"));
                urlFilenameMap.put(url, filename);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return urlFilenameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilename(@NonNull String url, @NonNull String filename) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues(2);
        values.put("url", url);
        values.put("filename", filename);
        Cursor c = null;
        String string = url.intern();
        synchronized (string) {
            try {
                String query = "SELECT filename FROM okdownloadResponseFilename WHERE url = ?";
                c = db.rawQuery("SELECT filename FROM okdownloadResponseFilename WHERE url = ?", new String[]{url});
                if (c.moveToFirst()) {
                    if (!filename.equals(c.getString(c.getColumnIndex("filename")))) {
                        db.replace(RESPONSE_FILENAME_TABLE_NAME, null, values);
                    }
                } else {
                    db.insert(RESPONSE_FILENAME_TABLE_NAME, null, values);
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
    }

    public void insert(@NonNull BreakpointInfo info) throws IOException {
        int blockCount = info.getBlockCount();
        SQLiteDatabase db = this.getWritableDatabase();
        for (int i = 0; i < blockCount; ++i) {
            BlockInfo blockInfo = info.getBlock(i);
            if (db.insert(BLOCK_TABLE_NAME, null, BreakpointSQLiteHelper.toValues(info.id, i, blockInfo)) != -1L) continue;
            throw new SQLiteException("insert block " + blockInfo + " failed!");
        }
        long result = db.insert(BREAKPOINT_TABLE_NAME, null, BreakpointSQLiteHelper.toValues(info));
        if (result == -1L) {
            throw new SQLiteException("insert info " + info + " failed!");
        }
    }

    public void updateBlockIncrease(@NonNull BreakpointInfo info, int blockIndex, long newCurrentOffset) {
        ContentValues values = new ContentValues();
        values.put("current_offset", Long.valueOf(newCurrentOffset));
        this.getWritableDatabase().update(BLOCK_TABLE_NAME, values, "breakpoint_id = ? AND block_index = ?", new String[]{Integer.toString(info.id), Integer.toString(blockIndex)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInfo(@NonNull BreakpointInfo info) throws IOException {
        SQLiteDatabase db = this.getWritableDatabase();
        Cursor cursor = null;
        db.beginTransaction();
        try {
            cursor = this.getWritableDatabase().rawQuery("SELECT id FROM breakpoint WHERE id =" + info.id + " LIMIT 1", null);
            if (!cursor.moveToNext()) {
                return;
            }
            this.removeInfo(info.id);
            this.insert(info);
            db.setTransactionSuccessful();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            db.endTransaction();
        }
    }

    public void removeInfo(int id) {
        this.getWritableDatabase().delete(BREAKPOINT_TABLE_NAME, "id = ?", new String[]{String.valueOf(id)});
        this.removeBlock(id);
    }

    public void removeBlock(int breakpointId) {
        this.getWritableDatabase().delete(BLOCK_TABLE_NAME, "breakpoint_id = ?", new String[]{String.valueOf(breakpointId)});
    }

    private static ContentValues toValues(@NonNull BreakpointInfo info) {
        ContentValues values = new ContentValues();
        values.put("id", Integer.valueOf(info.id));
        values.put("url", info.getUrl());
        values.put("etag", info.getEtag());
        values.put("parent_path", info.parentFile.getAbsolutePath());
        values.put("filename", info.getFilename());
        values.put("task_only_parent_path", Integer.valueOf(info.isTaskOnlyProvidedParentPath() ? 1 : 0));
        values.put("chunked", Integer.valueOf(info.isChunked() ? 1 : 0));
        return values;
    }

    private static ContentValues toValues(int breakpointId, int index, @NonNull BlockInfo info) {
        ContentValues values = new ContentValues();
        values.put("breakpoint_id", Integer.valueOf(breakpointId));
        values.put("block_index", Integer.valueOf(index));
        values.put("start_offset", Long.valueOf(info.getStartOffset()));
        values.put("content_length", Long.valueOf(info.getContentLength()));
        values.put("current_offset", Long.valueOf(info.getCurrentOffset()));
        return values;
    }
}

