/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.okdownload.core.breakpoint;

import android.support.annotation.NonNull;
import com.liulishuo.okdownload.core.breakpoint.RemitSyncExecutor;

class RemitSyncToDBHelper {
    private final RemitSyncExecutor executor;
    long delayMillis;

    RemitSyncToDBHelper(@NonNull RemitSyncExecutor.RemitAgent agent) {
        this(new RemitSyncExecutor(agent));
    }

    RemitSyncToDBHelper(@NonNull RemitSyncExecutor executor) {
        this.executor = executor;
        this.delayMillis = 1500L;
    }

    void shutdown() {
        this.executor.shutdown();
    }

    boolean isNotFreeToDatabase(int id) {
        return !this.executor.isFreeToDatabase(id);
    }

    void onTaskStart(int id) {
        this.executor.removePostWithId(id);
        this.executor.postSyncInfoDelay(id, this.delayMillis);
    }

    void endAndEnsureToDB(int id) {
        this.executor.removePostWithId(id);
        try {
            if (this.executor.isFreeToDatabase(id)) {
                return;
            }
            this.executor.postSync(id);
        }
        finally {
            this.executor.postRemoveFreeId(id);
        }
    }

    void discard(int id) {
        this.executor.removePostWithId(id);
        this.executor.postRemoveInfo(id);
    }
}

