package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;

import java.util.List;

/**
 * Created by ofira on 9/17/17.
 */

public class BadgeCounterRequest implements Command {

    private static final String TAG = "BadgeCounterRequest";
    private static final int BADGE_REQUEST_TIMEOUT = 30000;

    private String mPusherURL;
    private ICallback<String, Exception> mCallback;
    private List<String> mCertificates;

    public BadgeCounterRequest(String pusherURL, List<String> certificates, ICallback<String, Exception> callback) {
        mPusherURL = pusherURL;
        mCallback = callback;
        mCertificates = certificates;
    }

    @Override
    public void execute() {

        HttpGetRequest httpPostRequest = new HttpGetRequest(mPusherURL);
        httpPostRequest.setTimeout(BADGE_REQUEST_TIMEOUT);
        httpPostRequest.setCertificatePinningKeys(mCertificates);

        LPMobileLog.i(TAG, "Pusher url " + mPusherURL);

        httpPostRequest.setCallback(new ICallback<String, Exception>() {
            @Override
            public void onSuccess(final String json) {
                if (!TextUtils.isEmpty(json)) {
                    LPMobileLog.i(TAG, "onSuccess " + json);
                    if (mCallback != null) {
                        mCallback.onSuccess(json);
                        return;
                    }
                }
                mCallback.onError(new Exception("Error: empty response from the server"));
            }

            @Override
            public void onError(Exception exception) {
                if (exception != null) {
                    LPMobileLog.e(TAG, "onError " + exception.getMessage());
                    if (mCallback != null) {
                        mCallback.onError(exception);
                        return;
                    }
                }
                mCallback.onError(new Exception("Error: request failed"));
            }
        });
        HttpHandler.execute(httpPostRequest);
    }
}
