package com.liveperson.infra.network.http.requests;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.liveperson.infra.log.LPMobileLog;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * Created by nirni on 1/27/16.
 */
public class UnregisterPushRequest extends PushRequest {

	public static final String TAG = UnregisterPushRequest.class.getSimpleName();


	public UnregisterPushRequest(String pusherURL, String userId, String appId, List<String> certificates) {
		super(pusherURL, userId, appId, null, null, certificates);
	}

	@Override
	protected void handleResponse(String json) {
		if (!TextUtils.isEmpty(json)) {
			LPMobileLog.d(TAG, "onSuccess " + json);
			if (mCallback != null) {
				mCallback.onSuccess(null);
			}
		}else{
			LPMobileLog.e(TAG, "Unregister pusher with empty response");
		}
	}

	@Override
	protected void handleError(Exception exception) {
		if (exception != null) {
			LPMobileLog.d(TAG, "onError " + exception.getMessage());
			if (mCallback != null) {
				if (exception.getMessage().contains("Token not found")) {
					LPMobileLog.d(TAG, "handleError: token not found on pusher. Return success");
					mCallback.onSuccess(null);
					return;
				}
				mCallback.onError(new Exception("Failed to unregister to pusher. response message = " + exception.getMessage()));
			}
		}
	}

	@NonNull
	@Override
	protected JSONObject getBody() {

		JSONObject pusherJson = new JSONObject();

		try {
			pusherJson.put(KEY_APP_ID, mAppId);
			pusherJson.put(KEY_USER_ID, mUserId);
			pusherJson.put(KEY_PLATFORM, mPlatform);

		} catch (JSONException ignored) {}

		return pusherJson;
	}
}
