package com.liveperson.infra.sdkstatemachine;

import com.liveperson.infra.sdkstatemachine.events.InitEvent;
import com.liveperson.infra.sdkstatemachine.events.LogoutEvent;
import com.liveperson.infra.sdkstatemachine.events.PreLogoutCompletedEvent;
import com.liveperson.infra.sdkstatemachine.events.ShutDownCompletedEvent;
import com.liveperson.infra.sdkstatemachine.events.ShutDownEvent;
import com.liveperson.infra.statemachine.interfaces.IState;

/**
 * Created by shiranr on 04/05/2016.
 */
public abstract class BaseInfraState implements IState {
    protected final String TAG;
    protected final String name;

    public BaseInfraState(String name, String logTag) {
        this.name = name;
        this.TAG = logTag;
    }
    public String toString() {
        return this.name;
    }

    @Override
    public void actionOnEntry() {

    }

    @Override
    public void actionOnExit() {

    }

    public void visit(InitEvent initEvent) {

    }

    public void visit(ShutDownEvent shutDownEvent) {

    }

    public void visit(LogoutEvent logoutEvent) {

    }

    public void visit(ShutDownCompletedEvent shutDownCompletedEvent) {

    }

    public void visit(PreLogoutCompletedEvent preLogoutCompletedEvent) {


    }
}
