package com.liveperson.infra.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;

import java.util.Locale;

/**
 * Created by maayank on 27/04/2017.
 */

public class LanguageUtils {

	public static final String TAG = LanguageUtils.class.getSimpleName();

	public static String getLocale(@Nullable String language, @Nullable String country) {

		Context context = Infra.instance.getApplicationContext();
		Resources resources = context.getResources();

		Locale current = context.getResources().getConfiguration().locale;
		if (TextUtils.isEmpty(country)) {
			country = context.getResources().getConfiguration().locale.getCountry();
		}

		if (TextUtils.isEmpty(language)) {

			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
				language = resources.getConfiguration().getLocales().get(0).getLanguage();
			} else {
				language = resources.getConfiguration().locale.getLanguage();
			}

			language = getLanguageCode(language);
		}

		LPMobileLog.d(TAG, "the language is: "+language
				+ " country: " +country+
				" \ncurrent: [ country= "+current.getCountry() +
				" Language=" +current.getDisplayCountry()+
				" ] ");

		return language+"-"+country;
	}

	/**
	 * This method helps getting the right langauage ISO code, which suppose to be
	 * according to ISO-639-1, BUT, on some devices it still returns the deprecated ISO-639.
	 * <BR>
	 * Languages codes that are translated in this method:
	 * <ul>
	 * <li>Hebrew:  IW -> HE
	 * <li>Indonesian: IN -> ID
	 * <li>Yiddish: JI -> YI
	 * </ul>
	 *
	 * @param language - The language code
	 * @return The right code according to ISO-639-1
	 */
	public static String getLanguageCode(String language) {

		if (language.equalsIgnoreCase("iw")) {
			return "he";
		} else if (language.equalsIgnoreCase("in")) {
			return "id";
		} else if (language.equalsIgnoreCase("ji")) {
			return "yi";
		} else {
			return language;
		}
	}
}
