package com.liveperson.infra.utils;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;

import com.liveperson.infra.Infra;

/**
 * Created by ofira on 16/11/2015.
 */
public class LocalBroadcast {

    /**
     * Utils method to send local broadcast
     *
     * @param action - The broadcast action
     */
    public static void sendBroadcast(String action) {
        Intent sendIntent = new Intent(action);
        LocalBroadcastManager.getInstance(Infra.instance.getApplicationContext()).sendBroadcast(sendIntent);
    }

    /**
     * Utils method to send local broadcast with bundle
     *
     * @param action - The broadcast action
     * @param bundle - The Bundle of extras to add to this broadcast.
     */
    public static void sendBroadcast(String action, Bundle bundle) {
        Intent sendIntent = new Intent(action);
        sendIntent.putExtras(bundle);
        LocalBroadcastManager.getInstance(Infra.instance.getApplicationContext()).sendBroadcast(sendIntent);
    }

}
