package com.liveperson.infra.utils;

import android.text.TextUtils;

import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;

/**
 * Created by nirni on 12/6/16.
 */

public class VersionUtils {

	public static final String TAG = VersionUtils.class.getSimpleName();



	public VersionUtils() {

	}

	/**
	 * Check if the host version (current SDK version) is valid against the given minSdkVersion.
	 * minSdkVersion should be received from one of LP server as the minimum version.
	 * @param minSdkVersion
	 * @return true - if the current SDK version is smaller than the given minSdkVersion, false - otherwise
	 */
	public static boolean isValidSdkVersion(String minSdkVersion) {

		String hostVersion = Infra.instance.getHostVersion();

		if (versionCompare(hostVersion, minSdkVersion, TAG) < 0) {

			LPMobileLog.w(TAG, "isValidSdkVersion: Current SDK version (" + hostVersion + ") is smaller than the one from the server (" + minSdkVersion + "). ");
			return false;
		}

		LPMobileLog.d(TAG, "isValidSdkVersion: Version check is OK");
		return true;
	}

	/**
	 * return true if both provided versions are equal
	 * @param version1
	 * @param version2
	 * @return
	 */
	public static boolean isVersionsEqual(String version1, String version2) {
		return versionCompare(version1, version2, TAG) == 0;
	}
	/**
	 * Compares two version strings.
	 * <p/>
	 * Use this instead of String.compareTo() for a non-lexicographical
	 * comparison that works for version strings. e.g. "1.10".compareTo("1.6").
	 *
	 * @param str1 a string of ordinal numbers separated by decimal points.
	 * @param str2 a string of ordinal numbers separated by decimal points.
	 * @return The result is a negative integer if str1 is _numerically_ less than str2.
	 * The result is a positive integer if str1 is _numerically_ greater than str2.
	 * The result is zero if the strings are _numerically_ equal.
	 * @note It does not work if "1.10" is supposed to be equal to "1.10.0".
	 */
	private static Integer versionCompare(String str1, String str2, String logTag) throws NullPointerException {

		if (logTag != null) {
			LPMobileLog.d(logTag, "versionCompare str1 " + str1);
			LPMobileLog.d(logTag, "versionCompare str2 " + str2);
		}

		// If one of the version strings is null return 0 (equal)
		if (TextUtils.isEmpty(str1) || TextUtils.isEmpty(str2)) {
			LPMobileLog.w(TAG, "versionCompare: one of the compared version is null or empty");
			return 0;
		}

		String[] vals1 = str1.split("\\.");
		String[] vals2 = str2.split("\\.");

		int i = 0;
		// set index to first non-equal ordinal or length of shortest version string
		while (i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i])) {
			i++;
		}

		// compare first non-equal ordinal number
		if (i < vals1.length && i < vals2.length) {
			int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
			return Integer.signum(diff);
		}
		// the strings are equal or one string is a substring of the other
		// e.g. "1.2.3" = "1.2.3" or "1.2.3" < "1.2.3.4"
		else {
			return Integer.signum(vals1.length - vals2.length);
		}
	}


}
