/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import com.liveperson.infra.controller.AudioPlayable;
import com.liveperson.infra.log.LPMobileLog;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/liveperson/infra/controller/PlayingAudioManager;", "", "()V", "TAG", "", "mCurrentlyPlayingList", "", "Lcom/liveperson/infra/controller/AudioPlayable;", "getMCurrentlyPlayingList", "()Ljava/util/Set;", "addPlaying", "", "audioPlayable", "addPlayingAndStopOthers", "removePlaying", "stopAllCurrentlyPlaying", "stopPlaying", "toString", "infra_release"})
public final class PlayingAudioManager {
    private final String TAG = "PlayingAudioManager";
    @NotNull
    private final Set<AudioPlayable> mCurrentlyPlayingList = new HashSet();

    @NotNull
    public final Set<AudioPlayable> getMCurrentlyPlayingList() {
        return this.mCurrentlyPlayingList;
    }

    private final void addPlaying(AudioPlayable audioPlayable) {
        LPMobileLog.d(this.TAG, "addPlaying: adding " + audioPlayable);
        this.mCurrentlyPlayingList.add(audioPlayable);
        LPMobileLog.d(this.TAG, String.valueOf(this.toString()));
    }

    public final void addPlayingAndStopOthers(@NotNull AudioPlayable audioPlayable) {
        Intrinsics.checkParameterIsNotNull((Object)audioPlayable, (String)"audioPlayable");
        LPMobileLog.d(this.TAG, "addPlayingAndStopOthers: adding " + audioPlayable);
        this.stopAllCurrentlyPlaying();
        this.addPlaying(audioPlayable);
    }

    public final void removePlaying(@NotNull AudioPlayable audioPlayable) {
        Intrinsics.checkParameterIsNotNull((Object)audioPlayable, (String)"audioPlayable");
        LPMobileLog.d(this.TAG, "removePlaying: removing " + audioPlayable);
        this.mCurrentlyPlayingList.remove(audioPlayable);
        LPMobileLog.d(this.TAG, String.valueOf(this.toString()));
    }

    public final void stopPlaying(@NotNull AudioPlayable audioPlayable) {
        Intrinsics.checkParameterIsNotNull((Object)audioPlayable, (String)"audioPlayable");
        LPMobileLog.d(this.TAG, "stopPlaying: stopping and removing " + audioPlayable);
        audioPlayable.stopPlaying();
        this.removePlaying(audioPlayable);
    }

    public final void stopAllCurrentlyPlaying() {
        for (AudioPlayable audioPlayable : this.mCurrentlyPlayingList) {
            this.stopPlaying(audioPlayable);
        }
        LPMobileLog.d(this.TAG, String.valueOf(this.toString()));
    }

    @NotNull
    public String toString() {
        return "Currently in list " + this.mCurrentlyPlayingList.size() + " items. " + this.mCurrentlyPlayingList;
    }
}

