/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database.tables;

import android.database.sqlite.SQLiteDatabase;
import com.liveperson.infra.database.tables.BaseTable;
import com.liveperson.infra.log.LPMobileLog;

public class MessagesTable
implements BaseTable {
    private static final String TAG = MessagesTable.class.getSimpleName();
    public static final String MESSAGES_TABLE = "messages";
    public static final String KEY_SERVER_SEQUENCE = "serverSequence";
    public static final String KEY_TEXT = "text";
    public static final String KEY_CONTENT_TYPE = "contentType";
    public static final String KEY_STATUS = "status";
    public static final String KEY_DIALOG_ID = "dialogId";
    public static final String KEY_MESSAGE_TYPE = "type";
    public static final String KEY_TIMESTAMP = "timeStamp";
    public static final String KEY_ORIGINATOR_ID = "originatorId";
    public static final String KEY_EVENT_ID = "eventId";
    public static final String KEY_ENCRYPTION_VERSION = "encryptVer";
    public static final String ENCRYPTION_VERSION_CURSOR_AS_VALUE = "message_encryptVer";

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getCreateCommand() {
        return "create table " + MESSAGES_TABLE + "(" + "_id" + " integer primary key autoincrement," + KEY_EVENT_ID + " text UNIQUE," + KEY_SERVER_SEQUENCE + " integer," + KEY_DIALOG_ID + " text," + KEY_TEXT + " text not null," + KEY_CONTENT_TYPE + " text not null," + KEY_MESSAGE_TYPE + " integer not null," + KEY_STATUS + " integer not null," + KEY_ORIGINATOR_ID + " text," + KEY_TIMESTAMP + " big int not null," + KEY_ENCRYPTION_VERSION + " integer not null" + ");";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 6) {
            long startTime = System.currentTimeMillis();
            String tempTableName = "messagesOld";
            db.execSQL("ALTER TABLE messages RENAME TO " + tempTableName);
            db.execSQL(this.getCreateCommand());
            db.execSQL("insert into messages (eventId, serverSequence, dialogId, text, contentType, type, status, originatorId, timeStamp, encryptVer) select cast(_id as text) , serverSequence, convID, text, contentType, type, status, originatorId, timeStamp, encryptVer from " + tempTableName);
            db.execSQL("DROP TABLE " + tempTableName);
            LPMobileLog.d(TAG, "Finished upgrading Messages table total time = " + (System.currentTimeMillis() - startTime));
        }
    }

    public static String[] getProjection() {
        return new String[]{"_id", KEY_SERVER_SEQUENCE, KEY_DIALOG_ID, KEY_TEXT, KEY_CONTENT_TYPE, KEY_MESSAGE_TYPE, KEY_STATUS, KEY_EVENT_ID, KEY_ORIGINATOR_ID, KEY_TIMESTAMP, KEY_ENCRYPTION_VERSION};
    }
}

