/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.log.logreporter.loggos;

import android.text.TextUtils;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.log.logreporter.loggos.LoggosMessage;
import com.liveperson.infra.log.logreporter.loggos.logsender.HttpLogSender;
import com.liveperson.infra.log.logreporter.loggos.logsender.LogSender;
import com.liveperson.infra.log.logreporter.loggos.logsender.LogSenderCallback;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.LocalBroadcast;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public class Loggos
implements LogSenderCallback<Exception> {
    public static final String TAG = Loggos.class.getSimpleName();
    public static final String PREFS_KEY_LOGGOS_DOMAIN = "prefs_key_loggos_domain";
    public static final String PREFS_KEY_LOGGOS_TARGETID = "prefs_key_loggos_targetid";
    private static final String DEFAULT_BRANDID_FOR_PREFS = "default_brand";
    private static final String PREFS_KEY_LAST_TIME_ERROR_SENT_PREFS = "prefs_key_last_time_error_sent";
    public static final String CERTIFICATE_ERROR_ACTION = "certificate_error_action";
    private static final long NUM_OF_MILLISECONDS_BETWEEN_ERRORS = 3600000L;
    private static final int MAX_QUEUE_SIZE = 100;
    private LogSender mLogSender = new HttpLogSender();
    private String mTargetId;
    private String mDomain;
    private List<String> mCertificates;
    private final Object mQueueLock = new Object();
    private long mLastTimeErrorSent;
    private LinkedList<LoggosMessage> mMessageQueue = new LinkedList();

    public Loggos() {
        this.validateDomainAndBrand();
    }

    public void init(String targetId, String domain, List<String> certificates) {
        this.mTargetId = targetId;
        this.mDomain = domain;
        this.mCertificates = certificates;
        this.mLogSender.setCallback(new LogSenderCallback(){

            @Override
            public void onSuccess() {
            }

            public void onError(List list, Throwable exception) {
                if (exception instanceof SSLPeerUnverifiedException) {
                    String intentAction = Loggos.CERTIFICATE_ERROR_ACTION;
                    LocalBroadcast.sendBroadcast(intentAction);
                }
            }
        });
        LPMobileLog.d(TAG, "init: save domain: " + this.mDomain + ", targetId: " + this.mTargetId + " to prefs");
        PreferenceManager.getInstance().setStringValue(PREFS_KEY_LOGGOS_DOMAIN, DEFAULT_BRANDID_FOR_PREFS, this.mDomain);
        PreferenceManager.getInstance().setStringValue(PREFS_KEY_LOGGOS_TARGETID, DEFAULT_BRANDID_FOR_PREFS, this.mTargetId);
    }

    public void shutdown() {
        this.sendAllQueue();
    }

    public void sendMessageImmediately(LoggosMessage message) {
        LPMobileLog.d(TAG, "sendMessageImmediately: Sending message");
        if (message == null) {
            LPMobileLog.d(TAG, "sendMessage: log message is null. Did not send to Loggos");
            return;
        }
        if (this.mDomain == null || this.mTargetId == null || !this.isNetworkAvailable()) {
            LPMobileLog.d(TAG, "sendMessage: log sender is not initialized yet. Store the message for future sending");
            this.addMessageToQueue(message);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message.getAccountId())) {
            message.setAccountId(this.mTargetId);
        }
        this.addMessageToQueue(message);
        this.sendAllQueue();
    }

    public void addMessage(LoggosMessage message) {
        if (message == null) {
            LPMobileLog.d(TAG, "addMessage: log message is null. Did not send to Loggos");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message.getAccountId()) && this.mTargetId != null) {
            message.setAccountId(this.mTargetId);
        }
        this.addMessageToQueue(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToQueue(LoggosMessage message) {
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mMessageQueue.size() >= 100) {
                this.mMessageQueue.removeLast();
            }
            this.mMessageQueue.addFirst(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllQueue() {
        if (this.isNetworkAvailable() && this.isShouldSendError()) {
            ArrayList<LoggosMessage> listToSend = new ArrayList<LoggosMessage>();
            LPMobileLog.d(TAG, "sendAllQueue: Start: " + System.currentTimeMillis());
            Object object = this.mQueueLock;
            synchronized (object) {
                LPMobileLog.d(TAG, "sendAllQueue: Copy message list and clear " + this.mMessageQueue.size() + " messages");
                listToSend.addAll(this.mMessageQueue);
                this.mMessageQueue.clear();
                LPMobileLog.d(TAG, "sendAllQueue: Sending all repository, " + listToSend.size() + " messages");
                this.mLogSender.sendBulk(this.mDomain, listToSend, this.mCertificates);
                this.mLastTimeErrorSent = System.currentTimeMillis();
                PreferenceManager.getInstance().setLongValue(PREFS_KEY_LAST_TIME_ERROR_SENT_PREFS, DEFAULT_BRANDID_FOR_PREFS, this.mLastTimeErrorSent);
            }
            LPMobileLog.d(TAG, "sendAllQueue: End: " + System.currentTimeMillis());
        } else {
            LPMobileLog.d(TAG, "sendAllQueue: Network is not available or didn't pass enough time for next sending. Didn't send messages");
        }
    }

    private void validateDomainAndBrand() {
        if (this.mDomain == null) {
            this.mDomain = PreferenceManager.getInstance().getStringValue(PREFS_KEY_LOGGOS_DOMAIN, DEFAULT_BRANDID_FOR_PREFS, null);
            LPMobileLog.d(TAG, "validateDomainAndBrand: Get domain from preferences: " + this.mDomain);
        }
        if (this.mTargetId == null) {
            this.mTargetId = PreferenceManager.getInstance().getStringValue(PREFS_KEY_LOGGOS_TARGETID, DEFAULT_BRANDID_FOR_PREFS, null);
            LPMobileLog.d(TAG, "validateDomainAndBrand: Get targetId from preferences: " + this.mTargetId);
        }
    }

    private boolean isNetworkAvailable() {
        return InternetConnectionService.isNetworkAvailable();
    }

    public boolean isShouldSendError() {
        boolean needToSend;
        this.mLastTimeErrorSent = PreferenceManager.getInstance().getLongValue(PREFS_KEY_LAST_TIME_ERROR_SENT_PREFS, DEFAULT_BRANDID_FOR_PREFS, 0L);
        boolean bl = needToSend = System.currentTimeMillis() - this.mLastTimeErrorSent > 3600000L;
        if (!needToSend) {
            LPMobileLog.d(TAG, "Time from last error is less than 3600000 millis. No need to send to loggos");
        }
        return needToSend;
    }

    public String getTargetId() {
        return this.mTargetId;
    }

    public void setTargetId(String targetId) {
        this.mTargetId = targetId;
    }

    public String getDomain() {
        return this.mDomain;
    }

    public void setDomain(String domain) {
        this.mDomain = domain;
    }

    @Override
    public void onSuccess() {
        LPMobileLog.d(TAG, "onSuccess: Messages sent successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(List<LoggosMessage> messages, Exception e) {
        LPMobileLog.d(TAG, "onError: Error sending messages. Add them back to top of stack (exception: " + e + ")");
        Object object = this.mQueueLock;
        synchronized (object) {
            this.mMessageQueue.addAll(0, messages);
        }
    }
}

