/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.model;

import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.utils.EncryptionVersion;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Message {
    private static final String TAG = Message.class.getSimpleName();
    public static final String EXTRA_MESSAGE_TEXT = "EXTRA_MESSAGE_TEXT";
    private int mServerSequence = -1;
    private String mMessage;
    private String mContentType = "text/plain";
    private long mId;
    private String mDialogId;
    private long mTimeStamp;
    private String mOriginatorId;
    private String mEventId;

    public Message(String originatorId, String message, long timeStamp, String dialogId, String eventId, EncryptionVersion encryptionVersion) {
        this.mOriginatorId = originatorId;
        this.mMessage = DBEncryptionHelper.decrypt(encryptionVersion, message);
        this.mTimeStamp = timeStamp;
        this.mDialogId = dialogId;
        this.mEventId = eventId;
    }

    public String toString() {
        return String.format("Message %s\nDialog id %s\nTimeStamp %s\nEventId %s\nServerSequence %s\nOriginatorId %s", this.mMessage, this.mDialogId, this.mTimeStamp, this.mEventId, this.mServerSequence, this.mOriginatorId);
    }

    public long getLocalId() {
        return this.mId;
    }

    public void setMessageId(long messageId) {
        this.mId = messageId;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public String getFullTimeString() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.mTimeStamp);
        SimpleDateFormat format = new SimpleDateFormat("EEEE, MMMM d, yyyy 'at' h:mm a");
        return format.format(cal.getTime());
    }

    public String getDialogId() {
        return this.mDialogId;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public int getServerSequence() {
        return this.mServerSequence;
    }

    public String getOriginatorId() {
        return this.mOriginatorId;
    }

    public void setDialogId(String dialogId) {
        this.mDialogId = dialogId;
    }

    public void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    public void setEventId(String eventId) {
        this.mEventId = eventId;
    }

    public String getEventId() {
        return this.mEventId;
    }

    public void setServerSequence(int serverSequence) {
        this.mServerSequence = serverSequence;
    }
}

