/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.request;

import android.util.Pair;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

public abstract class HttpRequest {
    private static final String TAG = HttpRequest.class.getSimpleName();
    private static final int DEFAULT_TIMEOUT = 30000;
    private int mTimeout = 30000;
    private String mUrl;
    private HttpMethod mMethod;
    private boolean mFollowRedirect = true;
    private List<Pair<String, String>> mHeaders;
    protected HttpRequestBody mRequestBody;
    protected ICallback mCallback;
    private List<String> mCertificatePinningKeys;
    private static final String USER_AGENT = "User-Agent";
    private static final String ANDROID = "ANDROID";

    public HttpRequest(String url, HttpMethod method) {
        this.mUrl = url;
        this.mMethod = method;
        this.mHeaders = new ArrayList<Pair<String, String>>();
        this.mHeaders.add((Pair<String, String>)Pair.create((Object)USER_AGENT, (Object)ANDROID));
    }

    public void processResponse(Response response) {
        try {
            if (this.isResponseSuccessful(response)) {
                LPMobileLog.i(TAG, "onSuccess! " + response.code());
                if (this.mCallback != null) {
                    this.reportSuccess(response);
                }
            } else {
                LPMobileLog.i(TAG, "onResponseFailure " + response);
                if (this.mCallback != null) {
                    this.processErrorResponse(new Exception("On Response Error : " + (response == null ? "no Response" : " response code: " + response.code() + " body: " + response.body().string())));
                }
            }
        }
        catch (IOException e) {
            this.processErrorResponse(e);
        }
    }

    protected boolean isResponseSuccessful(Response response) {
        return response != null && response.isSuccessful();
    }

    public void processErrorResponse(Exception e) {
        LPMobileLog.w(TAG, " Error while sending http request :" + (e != null ? " Error msg: " + e.getMessage() : ""));
        if (this.mCallback != null) {
            this.mCallback.onError(e);
        }
    }

    protected void reportSuccess(Response response) throws IOException {
        this.mCallback.onSuccess(response == null ? "" : response.body().string());
    }

    public abstract HttpRequestBody getRequestBody();

    public abstract void setBody(HttpRequestBody var1);

    public void addHeader(String name, String value) {
        if (name.equals(USER_AGENT)) {
            this.mHeaders.set(0, (Pair<String, String>)Pair.create((Object)USER_AGENT, (Object)value));
        } else {
            this.mHeaders.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
        }
    }

    public List<Pair<String, String>> getHeaders() {
        return this.mHeaders;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String mUrl) {
        this.mUrl = mUrl;
    }

    public HttpMethod getMethod() {
        return this.mMethod;
    }

    public boolean getFollowRedirect() {
        return this.mFollowRedirect;
    }

    public List<String> getCertificatePinningKeys() {
        return this.mCertificatePinningKeys;
    }

    public void setFollowRedirect(boolean follow) {
        this.mFollowRedirect = follow;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public ICallback getCallback() {
        return this.mCallback;
    }

    public void setCertificatePinningKeys(List<String> certificatePinningKeys) {
        this.mCertificatePinningKeys = certificatePinningKeys;
    }

    public void setCallback(ICallback callback) {
        this.mCallback = callback;
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT;

    }
}

