/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import com.liveperson.infra.IDisposable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.IdleQueueHandler;
import com.liveperson.infra.utils.HandleMessageCallback;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;

public class DispatchQueue
extends HandlerThread
implements MessageQueue.IdleHandler,
IDisposable {
    private static final String TAG = DispatchQueue.class.getSimpleName();
    private volatile Handler mHandler = null;
    private IdleQueueHandler mIdleQueueHandler;
    private MessageQueue mMessageQueue;
    private HandleMessageCallback mHandleMessageCallback;
    private CountDownLatch mSyncLatch = new CountDownLatch(1);

    public DispatchQueue(String threadName) {
        this(threadName, 0);
    }

    public DispatchQueue(String threadName, int threadPriority) {
        this(threadName, threadPriority, null);
    }

    public DispatchQueue(String threadName, IdleQueueHandler idleQueue) {
        this(threadName, 0, idleQueue);
    }

    public DispatchQueue(String threadName, int threadPriority, IdleQueueHandler idleQueue) {
        super(threadName, threadPriority);
        this.mHandleMessageCallback = new HandleMessageCallback.NullHandleMessageCallback();
        this.mIdleQueueHandler = idleQueue;
        this.start();
    }

    protected void onLooperPrepared() {
        if (this.mIdleQueueHandler != null) {
            this.mMessageQueue = Looper.myQueue();
            this.mMessageQueue.addIdleHandler((MessageQueue.IdleHandler)this);
        }
        this.mHandler = new DispatchQueueHandler(this.getLooper(), this);
        this.mSyncLatch.countDown();
    }

    public void setHandleMessageCallback(final HandleMessageCallback callback) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                DispatchQueue.this.mHandleMessageCallback = callback;
            }
        });
    }

    public void unregisterQueueIdleCallbacks() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                DispatchQueue.this.mIdleQueueHandler = null;
            }
        });
    }

    public void sendMessage(Message msg) {
        this.sendMessage(msg, 0);
    }

    public void sendMessage(Message msg, int delay) {
        try {
            this.mSyncLatch.await();
            this.mHandler.sendMessageDelayed(msg, (long)delay);
        }
        catch (Exception e) {
            LPMobileLog.e(TAG + this.getName(), "Handler is not ready");
        }
    }

    public void postRunnable(Runnable runnable) {
        this.postRunnable(runnable, 0L);
    }

    public void postRunnable(Runnable runnable, long delay) {
        try {
            this.mSyncLatch.await();
            this.mHandler.postDelayed(runnable, delay);
        }
        catch (Exception e) {
            LPMobileLog.e(TAG + this.getName(), "Handler is not ready");
        }
    }

    public void removeRunnable(Runnable runnable) {
        try {
            this.mSyncLatch.await();
            this.mHandler.removeCallbacks(runnable);
        }
        catch (Exception e) {
            LPMobileLog.e(TAG + this.getName(), "Handler is not ready");
        }
    }

    public boolean removeMessage(int messageWhat) {
        try {
            this.mSyncLatch.await();
            if (this.mHandler.hasMessages(messageWhat)) {
                this.mHandler.removeMessages(messageWhat);
                return true;
            }
        }
        catch (Exception e) {
            LPMobileLog.e(TAG + this.getName(), "Handler is not ready");
        }
        return false;
    }

    public void cleanupQueue() {
        try {
            this.mSyncLatch.await();
            this.mHandler.removeCallbacksAndMessages(null);
        }
        catch (Exception e) {
            LPMobileLog.e(TAG + this.getName(), "Handler is not ready");
        }
    }

    public boolean queueIdle() {
        if (this.mIdleQueueHandler != null) {
            this.mIdleQueueHandler.queueIdle();
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        try {
            this.mSyncLatch.await();
            if (this.mMessageQueue != null) {
                this.mMessageQueue.removeIdleHandler((MessageQueue.IdleHandler)this);
            }
            this.mHandler.getLooper().quit();
            this.quit();
            LPMobileLog.d(TAG, "dispose " + Thread.currentThread().getName());
        }
        catch (Exception e) {
            LPMobileLog.e(TAG + this.getName(), "Handler is not ready");
        }
    }

    public boolean isCurrentThread() {
        try {
            this.mSyncLatch.await();
            return this.mHandler.getLooper().getThread() == Thread.currentThread();
        }
        catch (Exception e) {
            LPMobileLog.e(TAG + " " + this.getName(), "Handler latch problem");
            return false;
        }
    }

    private static class DispatchQueueHandler
    extends Handler {
        private final WeakReference<DispatchQueue> dispatchQueue;

        public DispatchQueueHandler(Looper looper, DispatchQueue dispatchQueue) {
            super(looper);
            this.dispatchQueue = new WeakReference<DispatchQueue>(dispatchQueue);
        }

        public void handleMessage(Message msg) {
            DispatchQueue dispatchQueue = (DispatchQueue)this.dispatchQueue.get();
            if (dispatchQueue != null) {
                dispatchQueue.mHandleMessageCallback.onHandleMessage(msg);
            }
        }
    }
}

