/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;
import java.util.Locale;

public class LanguageUtils {
    public static final String TAG = LanguageUtils.class.getSimpleName();

    public static String getLocale(@Nullable String language, @Nullable String country) {
        Context context = Infra.instance.getApplicationContext();
        Resources resources = context.getResources();
        Locale current = context.getResources().getConfiguration().locale;
        if (TextUtils.isEmpty((CharSequence)country)) {
            country = context.getResources().getConfiguration().locale.getCountry();
        }
        if (TextUtils.isEmpty((CharSequence)language)) {
            language = Build.VERSION.SDK_INT >= 24 ? resources.getConfiguration().getLocales().get(0).getLanguage() : resources.getConfiguration().locale.getLanguage();
            language = LanguageUtils.getLanguageCode(language);
        }
        LPMobileLog.d(TAG, "the language is: " + language + " country: " + country + " \ncurrent: [ country= " + current.getCountry() + " Language=" + current.getDisplayCountry() + " ] ");
        return language + "-" + country;
    }

    public static String getLanguageCode(String language) {
        if (language.equalsIgnoreCase("iw")) {
            return "he";
        }
        if (language.equalsIgnoreCase("in")) {
            return "id";
        }
        if (language.equalsIgnoreCase("ji")) {
            return "yi";
        }
        return language;
    }
}

