/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liveperson.infra.R;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.LinkPreviewCallback;
import com.liveperson.infra.utils.RegexUtil;
import com.liveperson.infra.utils.SourceContent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TextCrawler {
    private static final String TAG = TextCrawler.class.getSimpleName();
    private static final String KEY_HTML_TAG_HEAD_OPEN = "<head>";
    private static final String KEY_HTML_TAG_HEAD_CLOSE = "</head>";
    private static final String KEY_HTML_TAG_TITLE = "title";
    private static final String KEY_HTML_TAG_DESCRIPTION = "description";
    private static final String KEY_HTML_TAG_SITE_NAME = "site_name";
    private static final String KEY_EMPTY = "";
    private static final String KEY_HTML_TAG_IMAGE = "image";
    private static final String KEY_HTML_TAG_URL = "url";
    public static final int TIMEOUT_IN_MILLI = 1500;
    private final String HTTP_PROTOCOL = "http://";
    private final String HTTPS_PROTOCOL = "https://";
    private final String WWW_SUBDOMAIN = "www.";
    private LinkPreviewCallback mCallback;
    private SourceContent mSourceContent;
    private GetCode mGetCode;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE_SECONDS = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private final BlockingQueue<Runnable> mDecodeWorkQueue = new LinkedBlockingQueue<Runnable>();

    public void makePreview(LinkPreviewCallback callback, String url) {
        this.mCallback = callback;
        this.mSourceContent = new SourceContent();
        if (this.mGetCode != null) {
            this.mGetCode.cancel(true);
            this.mGetCode = null;
        }
        this.mGetCode = new GetCode();
        ThreadPoolExecutor mDecodeThreadPool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 2L, KEEP_ALIVE_TIME_UNIT, this.mDecodeWorkQueue);
        this.mGetCode.executeOnExecutor(mDecodeThreadPool, new String[]{url});
    }

    private ArrayList<String> matches(String text, int results) {
        String[] splitString;
        ArrayList<String> urls = new ArrayList<String>();
        if (text == null) {
            LPMobileLog.w(TAG, "matches: given text is null");
            return urls;
        }
        text = text.replaceAll("\u200b", KEY_EMPTY);
        text = text.replaceAll("\u200c", KEY_EMPTY);
        text = text.replaceAll("\u200c", KEY_EMPTY);
        text = text.replaceAll("\ufeff", KEY_EMPTY);
        for (String string2 : splitString = text.split("\\s+")) {
            if (string2.startsWith("www.")) {
                string2 = "https://" + string2;
            }
            try {
                URL item = new URL(string2);
                urls.add(item.toString());
            }
            catch (Exception e) {
                LPMobileLog.e(TAG, "ERROR: " + e);
            }
            if (results == 1 && urls.size() > 0) break;
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseHtml(String[] params) {
        ArrayList<String> urls = this.matches(params[0], 0);
        if (this.mSourceContent == null) {
            this.mSourceContent = new SourceContent();
        }
        if (urls.size() <= 0) {
            this.mSourceContent.setFinalUrl(KEY_EMPTY);
        } else {
            this.mSourceContent.setFinalUrl(TextCrawler.extendedTrim(urls.get(0)));
            StringBuilder myString = new StringBuilder();
            HttpURLConnection hc = null;
            try {
                String matchTitle;
                String thisLine;
                URL u = new URL(this.mSourceContent.getFinalUrl());
                hc = (HttpURLConnection)u.openConnection();
                hc.setConnectTimeout(1500);
                hc.setRequestProperty("User-Agent", "Mozilla");
                String charset = this.getCharsetEncoding(hc.getContentType());
                BufferedReader br = new BufferedReader(new InputStreamReader(hc.getInputStream(), charset));
                while ((thisLine = br.readLine()) != null) {
                    myString.append(thisLine);
                }
                br.close();
                if (TextUtils.isEmpty((CharSequence)myString)) {
                    throw new IOException("the url is empty");
                }
                if (myString.indexOf(KEY_HTML_TAG_HEAD_OPEN) == -1) {
                    this.mSourceContent.setHtmlCode(TextCrawler.extendedTrim(myString.toString()));
                } else {
                    this.mSourceContent.setHtmlCode(TextCrawler.extendedTrim(myString.substring(myString.indexOf(KEY_HTML_TAG_HEAD_OPEN), myString.lastIndexOf(KEY_HTML_TAG_HEAD_CLOSE) + KEY_HTML_TAG_HEAD_CLOSE.length())));
                }
                HashMap<String, String> metaTags = this.getMetaTags(this.mSourceContent.getHtmlCode());
                this.mSourceContent.setMetaTags(metaTags);
                this.mSourceContent.setTitle(metaTags.get(KEY_HTML_TAG_TITLE));
                this.mSourceContent.setDescription(metaTags.get(KEY_HTML_TAG_DESCRIPTION));
                this.mSourceContent.setSiteName(metaTags.get(KEY_HTML_TAG_SITE_NAME));
                if (this.mSourceContent.getTitle().equals(KEY_EMPTY) && !(matchTitle = RegexUtil.pregMatch(this.mSourceContent.getHtmlCode(), "<title(.*?)>(.*?)</title>", 2)).equals(KEY_EMPTY)) {
                    this.mSourceContent.setTitle(matchTitle);
                }
                this.mSourceContent.setDescription(this.mSourceContent.getDescription().replaceAll("<script(.*?)>(.*?)</script>", KEY_EMPTY));
                if (!metaTags.get(KEY_HTML_TAG_IMAGE).equals(KEY_EMPTY)) {
                    this.mSourceContent.setImages(metaTags.get(KEY_HTML_TAG_IMAGE));
                }
                this.mSourceContent.setSuccess(true);
            }
            catch (Exception e) {
                this.mSourceContent.setSuccess(false);
                this.mSourceContent.setUrl(KEY_EMPTY);
                this.mSourceContent.setHtmlCode(KEY_EMPTY);
                LPMobileLog.w(TAG, "url error: " + e);
            }
            finally {
                if (hc != null) {
                    hc.disconnect();
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSourceContent.getFinalUrl())) {
            String[] finalLinkSet = this.mSourceContent.getFinalUrl().split("&");
            this.mSourceContent.setUrl(finalLinkSet[0]);
            this.mSourceContent.setCannonicalUrl(this.cannonicalPage(this.mSourceContent.getFinalUrl()));
            this.mSourceContent.setDescription(this.mSourceContent.getDescription());
            this.mSourceContent.setSiteName(this.mSourceContent.getSiteName());
        }
    }

    @NonNull
    private String getCharsetEncoding(String contentType) {
        String charset = KEY_EMPTY;
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            String[] values;
            for (String value : values = contentType.split(";")) {
                if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
                charset = value.substring("charset=".length());
            }
        }
        if (KEY_EMPTY.equals(charset)) {
            charset = "UTF-8";
        }
        return charset;
    }

    private String cannonicalPage(String url) {
        String cannonical = KEY_EMPTY;
        if (url.startsWith("http://")) {
            url = url.substring("http://".length());
        } else if (url.startsWith("https://")) {
            url = url.substring("https://".length());
        }
        int urlLength = url.length();
        for (int i = 0; i < urlLength && url.charAt(i) != '/'; ++i) {
            cannonical = cannonical + url.charAt(i);
        }
        return cannonical;
    }

    private boolean isImage(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && url.matches("(.+?)\\.(jpg|png|gif|bmp)$");
    }

    private HashMap<String, String> getMetaTags(String content) {
        HashMap<String, String> metaTags = new HashMap<String, String>();
        metaTags.put(KEY_HTML_TAG_URL, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_TITLE, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_DESCRIPTION, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_IMAGE, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_SITE_NAME, KEY_EMPTY);
        List<String> matches = RegexUtil.pregMatchAll(content, "<meta(.*?)>", 1);
        for (String match : matches) {
            String lowerCase = match.toLowerCase();
            if (Configuration.getBoolean(R.bool.link_preview_to_use_more_than_og_tags)) {
                if (lowerCase.contains("name=\"url\"") || lowerCase.contains("name='url'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_URL, this.separeMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"title\"") || lowerCase.contains("name='title'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_TITLE, this.separeMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"description\"") || lowerCase.contains("name='description'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_DESCRIPTION, this.separeMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"image\"") || lowerCase.contains("name='image'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_IMAGE, this.separeMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"site_name\"") || lowerCase.contains("name='site_name'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_SITE_NAME, this.separeMetaTagsContent(match));
                }
            }
            if (lowerCase.contains("property=\"og:url\"") || lowerCase.contains("property='og:url'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_URL, this.separeMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:title\"") || lowerCase.contains("property='og:title'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_TITLE, this.separeMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:description\"") || lowerCase.contains("property='og:description'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_DESCRIPTION, this.separeMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:image\"") || lowerCase.contains("property='og:image'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_IMAGE, this.separeMetaTagsContent(match));
                continue;
            }
            if (!lowerCase.contains("property=\"og:site_name\"") && !lowerCase.contains("property='og:site_name'")) continue;
            this.updateMetaTag(metaTags, KEY_HTML_TAG_SITE_NAME, this.separeMetaTagsContent(match));
        }
        return metaTags;
    }

    private void updateMetaTag(HashMap<String, String> metaTags, String url, String value) {
        if (value != null && value.length() > 0) {
            metaTags.put(url, value);
        }
    }

    private String separeMetaTagsContent(String content) {
        return RegexUtil.pregMatch(content, "content=\"(.*?)\"", 1);
    }

    static String extendedTrim(String content) {
        return TextUtils.isEmpty((CharSequence)content) ? KEY_EMPTY : content.replaceAll("\\s+", " ").replace("\n", " ").replace("\r", " ").trim();
    }

    public SourceContent getSourceContent() {
        return this.mSourceContent;
    }

    public class GetCode
    extends AsyncTask<String, Void, Void> {
        GetCode() {
        }

        protected void onPreExecute() {
            if (TextCrawler.this.mCallback != null) {
                TextCrawler.this.mCallback.onPre();
            }
            super.onPreExecute();
        }

        protected void onPostExecute(Void result) {
            if (TextCrawler.this.mCallback != null) {
                TextCrawler.this.mCallback.onPos(TextCrawler.this.mSourceContent, this.isNull());
            }
            super.onPostExecute((Object)result);
        }

        protected Void doInBackground(String ... params) {
            TextCrawler.this.parseHtml(params);
            return null;
        }

        public boolean isNull() {
            return !TextCrawler.this.mSourceContent.isSuccess() && TextCrawler.extendedTrim(TextCrawler.this.mSourceContent.getHtmlCode()).equals(TextCrawler.KEY_EMPTY);
        }
    }
}

