/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;

public class VersionUtils {
    public static final String TAG = VersionUtils.class.getSimpleName();

    public static boolean isValidSdkVersion(String minSdkVersion) {
        String hostVersion = Infra.instance.getHostVersion();
        if (VersionUtils.versionCompare(hostVersion, minSdkVersion, TAG) < 0) {
            LPMobileLog.w(TAG, "isValidSdkVersion: Current SDK version (" + hostVersion + ") is smaller than the one from the server (" + minSdkVersion + "). ");
            return false;
        }
        LPMobileLog.d(TAG, "isValidSdkVersion: Version check is OK");
        return true;
    }

    public static boolean isVersionsEqual(String version1, String version2) {
        return VersionUtils.versionCompare(version1, version2, TAG) == 0;
    }

    private static Integer versionCompare(String str1, String str2, String logTag) throws NullPointerException {
        int i;
        if (logTag != null) {
            LPMobileLog.d(logTag, "versionCompare str1 " + str1);
            LPMobileLog.d(logTag, "versionCompare str2 " + str2);
        }
        if (TextUtils.isEmpty((CharSequence)str1) || TextUtils.isEmpty((CharSequence)str2)) {
            LPMobileLog.w(TAG, "versionCompare: one of the compared version is null or empty");
            return 0;
        }
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }
}

