/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.NetworkInfo;
import android.os.Build;
import com.liveperson.infra.utils.picasso.Action;
import com.liveperson.infra.utils.picasso.Cache;
import com.liveperson.infra.utils.picasso.Dispatcher;
import com.liveperson.infra.utils.picasso.MarkableInputStream;
import com.liveperson.infra.utils.picasso.MemoryPolicy;
import com.liveperson.infra.utils.picasso.NetworkPolicy;
import com.liveperson.infra.utils.picasso.NetworkRequestHandler;
import com.liveperson.infra.utils.picasso.Picasso;
import com.liveperson.infra.utils.picasso.Request;
import com.liveperson.infra.utils.picasso.RequestHandler;
import com.liveperson.infra.utils.picasso.Stats;
import com.liveperson.infra.utils.picasso.Transformation;
import com.liveperson.infra.utils.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

class BitmapHunter
implements Runnable {
    private static final Object DECODE_LOCK = new Object();
    private static final ThreadLocal<StringBuilder> NAME_BUILDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder("Picasso-");
        }
    };
    private static final AtomicInteger SEQUENCE_GENERATOR = new AtomicInteger();
    private static final RequestHandler ERRORING_HANDLER = new RequestHandler(){

        @Override
        public boolean canHandleRequest(Request data) {
            return true;
        }

        @Override
        public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
            throw new IllegalStateException("Unrecognized type of request: " + request);
        }
    };
    final int sequence = SEQUENCE_GENERATOR.incrementAndGet();
    final Picasso picasso;
    final Dispatcher dispatcher;
    final Cache cache;
    final Stats stats;
    final String key;
    final Request data;
    final int memoryPolicy;
    int networkPolicy;
    final RequestHandler requestHandler;
    Action action;
    List<Action> actions;
    Bitmap result;
    Future<?> future;
    Picasso.LoadedFrom loadedFrom;
    Exception exception;
    int exifOrientation;
    int retryCount;
    Picasso.Priority priority;

    BitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, RequestHandler requestHandler) {
        this.picasso = picasso;
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.stats = stats;
        this.action = action;
        this.key = action.getKey();
        this.data = action.getRequest();
        this.priority = action.getPriority();
        this.memoryPolicy = action.getMemoryPolicy();
        this.networkPolicy = action.getNetworkPolicy();
        this.requestHandler = requestHandler;
        this.retryCount = requestHandler.getRetryCount();
    }

    static Bitmap decodeStream(Source source, Request request) throws IOException {
        Bitmap bitmap;
        BufferedSource bufferedSource = Okio.buffer((Source)source);
        boolean isWebPFile = Utils.isWebPFile(bufferedSource);
        boolean isPurgeable = request.purgeable && Build.VERSION.SDK_INT < 21;
        BitmapFactory.Options options = RequestHandler.createBitmapOptions(request);
        boolean calculateSize = RequestHandler.requiresInSampleSize(options);
        if (isWebPFile || isPurgeable) {
            byte[] bytes = bufferedSource.readByteArray();
            if (calculateSize) {
                BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
                RequestHandler.calculateInSampleSize(request.targetWidth, request.targetHeight, options, request);
            }
            return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        }
        InputStream stream = bufferedSource.inputStream();
        if (calculateSize) {
            MarkableInputStream markStream = new MarkableInputStream(stream);
            stream = markStream;
            markStream.allowMarksToExpire(false);
            long mark = markStream.savePosition(1024);
            BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            RequestHandler.calculateInSampleSize(request.targetWidth, request.targetHeight, options, request);
            markStream.reset(mark);
            markStream.allowMarksToExpire(true);
        }
        if ((bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options)) == null) {
            throw new IOException("Failed to decode stream.");
        }
        return bitmap;
    }

    @Override
    public void run() {
        try {
            BitmapHunter.updateThreadName(this.data);
            if (this.picasso.loggingEnabled) {
                Utils.log("Hunter", "executing", Utils.getLogIdsForHunter(this));
            }
            this.result = this.hunt();
            if (this.result == null) {
                this.dispatcher.dispatchFailed(this);
            } else {
                this.dispatcher.dispatchComplete(this);
            }
        }
        catch (NetworkRequestHandler.ResponseException e) {
            if (!NetworkPolicy.isOfflineOnly(e.networkPolicy) || e.code != 504) {
                this.exception = e;
            }
            this.dispatcher.dispatchFailed(this);
        }
        catch (IOException e) {
            this.exception = e;
            this.dispatcher.dispatchRetry(this);
        }
        catch (OutOfMemoryError e) {
            StringWriter writer = new StringWriter();
            this.stats.createSnapshot().dump(new PrintWriter(writer));
            this.exception = new RuntimeException(writer.toString(), e);
            this.dispatcher.dispatchFailed(this);
        }
        catch (Exception e) {
            this.exception = e;
            this.dispatcher.dispatchFailed(this);
        }
        finally {
            Thread.currentThread().setName("Picasso-Idle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap hunt() throws IOException {
        Bitmap bitmap = null;
        if (MemoryPolicy.shouldReadFromMemoryCache(this.memoryPolicy) && (bitmap = this.cache.get(this.key)) != null) {
            this.stats.dispatchCacheHit();
            this.loadedFrom = Picasso.LoadedFrom.MEMORY;
            if (this.picasso.loggingEnabled) {
                Utils.log("Hunter", "decoded", this.data.logId(), "from cache");
            }
            return bitmap;
        }
        this.networkPolicy = this.retryCount == 0 ? NetworkPolicy.OFFLINE.index : this.networkPolicy;
        RequestHandler.Result result = this.requestHandler.load(this.data, this.networkPolicy);
        if (result != null) {
            this.loadedFrom = result.getLoadedFrom();
            this.exifOrientation = result.getExifOrientation();
            bitmap = result.getBitmap();
            if (bitmap == null) {
                Source source = result.getSource();
                try {
                    bitmap = BitmapHunter.decodeStream(source, this.data);
                }
                finally {
                    try {
                        source.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (bitmap != null) {
            if (this.picasso.loggingEnabled) {
                Utils.log("Hunter", "decoded", this.data.logId());
            }
            this.stats.dispatchBitmapDecoded(bitmap);
            if (this.data.needsTransformation() || this.exifOrientation != 0) {
                Object object = DECODE_LOCK;
                synchronized (object) {
                    if (this.data.needsMatrixTransform() || this.exifOrientation != 0) {
                        bitmap = BitmapHunter.transformResult(this.data, bitmap, this.exifOrientation);
                        if (this.picasso.loggingEnabled) {
                            Utils.log("Hunter", "transformed", this.data.logId());
                        }
                    }
                    if (this.data.hasCustomTransformations()) {
                        bitmap = BitmapHunter.applyCustomTransformations(this.data.transformations, bitmap);
                        if (this.picasso.loggingEnabled) {
                            Utils.log("Hunter", "transformed", this.data.logId(), "from custom transformations");
                        }
                    }
                }
                if (bitmap != null) {
                    this.stats.dispatchBitmapTransformed(bitmap);
                }
            }
        }
        return bitmap;
    }

    void attach(Action action) {
        Picasso.Priority actionPriority;
        boolean loggingEnabled = this.picasso.loggingEnabled;
        Request request = action.request;
        if (this.action == null) {
            this.action = action;
            if (loggingEnabled) {
                if (this.actions == null || this.actions.isEmpty()) {
                    Utils.log("Hunter", "joined", request.logId(), "to empty hunter");
                } else {
                    Utils.log("Hunter", "joined", request.logId(), Utils.getLogIdsForHunter(this, "to "));
                }
            }
            return;
        }
        if (this.actions == null) {
            this.actions = new ArrayList<Action>(3);
        }
        this.actions.add(action);
        if (loggingEnabled) {
            Utils.log("Hunter", "joined", request.logId(), Utils.getLogIdsForHunter(this, "to "));
        }
        if ((actionPriority = action.getPriority()).ordinal() > this.priority.ordinal()) {
            this.priority = actionPriority;
        }
    }

    void detach(Action action) {
        boolean detached = false;
        if (this.action == action) {
            this.action = null;
            detached = true;
        } else if (this.actions != null) {
            detached = this.actions.remove(action);
        }
        if (detached && action.getPriority() == this.priority) {
            this.priority = this.computeNewPriority();
        }
        if (this.picasso.loggingEnabled) {
            Utils.log("Hunter", "removed", action.request.logId(), Utils.getLogIdsForHunter(this, "from "));
        }
    }

    private Picasso.Priority computeNewPriority() {
        boolean hasAny;
        Picasso.Priority newPriority = Picasso.Priority.LOW;
        boolean hasMultiple = this.actions != null && !this.actions.isEmpty();
        boolean bl = hasAny = this.action != null || hasMultiple;
        if (!hasAny) {
            return newPriority;
        }
        if (this.action != null) {
            newPriority = this.action.getPriority();
        }
        if (hasMultiple) {
            int n = this.actions.size();
            for (int i = 0; i < n; ++i) {
                Picasso.Priority actionPriority = this.actions.get(i).getPriority();
                if (actionPriority.ordinal() <= newPriority.ordinal()) continue;
                newPriority = actionPriority;
            }
        }
        return newPriority;
    }

    boolean cancel() {
        return this.action == null && (this.actions == null || this.actions.isEmpty()) && this.future != null && this.future.cancel(false);
    }

    boolean isCancelled() {
        return this.future != null && this.future.isCancelled();
    }

    boolean shouldRetry(boolean airplaneMode, NetworkInfo info) {
        boolean hasRetries;
        boolean bl = hasRetries = this.retryCount > 0;
        if (!hasRetries) {
            return false;
        }
        --this.retryCount;
        return this.requestHandler.shouldRetry(airplaneMode, info);
    }

    boolean supportsReplay() {
        return this.requestHandler.supportsReplay();
    }

    Bitmap getResult() {
        return this.result;
    }

    String getKey() {
        return this.key;
    }

    int getMemoryPolicy() {
        return this.memoryPolicy;
    }

    Request getData() {
        return this.data;
    }

    Action getAction() {
        return this.action;
    }

    Picasso getPicasso() {
        return this.picasso;
    }

    List<Action> getActions() {
        return this.actions;
    }

    Exception getException() {
        return this.exception;
    }

    Picasso.LoadedFrom getLoadedFrom() {
        return this.loadedFrom;
    }

    Picasso.Priority getPriority() {
        return this.priority;
    }

    static void updateThreadName(Request data) {
        String name = data.getName();
        StringBuilder builder = NAME_BUILDER.get();
        builder.ensureCapacity("Picasso-".length() + name.length());
        builder.replace("Picasso-".length(), builder.length(), name);
        Thread.currentThread().setName(builder.toString());
    }

    static BitmapHunter forRequest(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        Request request = action.getRequest();
        List<RequestHandler> requestHandlers = picasso.getRequestHandlers();
        int count = requestHandlers.size();
        for (int i = 0; i < count; ++i) {
            RequestHandler requestHandler = requestHandlers.get(i);
            if (!requestHandler.canHandleRequest(request)) continue;
            return new BitmapHunter(picasso, dispatcher, cache, stats, action, requestHandler);
        }
        return new BitmapHunter(picasso, dispatcher, cache, stats, action, ERRORING_HANDLER);
    }

    static Bitmap applyCustomTransformations(List<Transformation> transformations, Bitmap result) {
        int count = transformations.size();
        for (int i = 0; i < count; ++i) {
            Bitmap newResult;
            final Transformation transformation = transformations.get(i);
            try {
                newResult = transformation.transform(result);
            }
            catch (RuntimeException e) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException("Transformation " + transformation.key() + " crashed with exception.", e);
                    }
                });
                return null;
            }
            if (newResult == null) {
                final StringBuilder builder = new StringBuilder().append("Transformation ").append(transformation.key()).append(" returned null after ").append(i).append(" previous transformation(s).\n\nTransformation list:\n");
                for (Transformation t : transformations) {
                    builder.append(t.key()).append('\n');
                }
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new NullPointerException(builder.toString());
                    }
                });
                return null;
            }
            if (newResult == result && result.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " returned input Bitmap but recycled it.");
                    }
                });
                return null;
            }
            if (newResult != result && !result.isRecycled()) {
                Picasso.HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new IllegalStateException("Transformation " + transformation.key() + " mutated input Bitmap but failed to recycle the original.");
                    }
                });
                return null;
            }
            result = newResult;
        }
        return result;
    }

    static Bitmap transformResult(Request data, Bitmap result, int exifOrientation) {
        Bitmap newResult;
        int inWidth = result.getWidth();
        int inHeight = result.getHeight();
        boolean onlyScaleDown = data.onlyScaleDown;
        int drawX = 0;
        int drawY = 0;
        int drawWidth = inWidth;
        int drawHeight = inHeight;
        Matrix matrix = new Matrix();
        if (data.needsMatrixTransform() || exifOrientation != 0) {
            int targetWidth = data.targetWidth;
            int targetHeight = data.targetHeight;
            float targetRotation = data.rotationDegrees;
            if (targetRotation != 0.0f) {
                double x1T;
                double cosR = Math.cos(Math.toRadians(targetRotation));
                double sinR = Math.sin(Math.toRadians(targetRotation));
                if (data.hasRotationPivot) {
                    matrix.setRotate(targetRotation, data.rotationPivotX, data.rotationPivotY);
                    x1T = (double)data.rotationPivotX * (1.0 - cosR) + (double)data.rotationPivotY * sinR;
                    double y1T = (double)data.rotationPivotY * (1.0 - cosR) - (double)data.rotationPivotX * sinR;
                    double x2T = x1T + (double)data.targetWidth * cosR;
                    double y2T = y1T + (double)data.targetWidth * sinR;
                    double x3T = x1T + (double)data.targetWidth * cosR - (double)data.targetHeight * sinR;
                    double y3T = y1T + (double)data.targetWidth * sinR + (double)data.targetHeight * cosR;
                    double x4T = x1T - (double)data.targetHeight * sinR;
                    double y4T = y1T + (double)data.targetHeight * cosR;
                    double maxX = Math.max(x4T, Math.max(x3T, Math.max(x1T, x2T)));
                    double minX = Math.min(x4T, Math.min(x3T, Math.min(x1T, x2T)));
                    double maxY = Math.max(y4T, Math.max(y3T, Math.max(y1T, y2T)));
                    double minY = Math.min(y4T, Math.min(y3T, Math.min(y1T, y2T)));
                    targetWidth = (int)Math.floor(maxX - minX);
                    targetHeight = (int)Math.floor(maxY - minY);
                } else {
                    matrix.setRotate(targetRotation);
                    x1T = 0.0;
                    double y1T = 0.0;
                    double x2T = (double)data.targetWidth * cosR;
                    double y2T = (double)data.targetWidth * sinR;
                    double x3T = (double)data.targetWidth * cosR - (double)data.targetHeight * sinR;
                    double y3T = (double)data.targetWidth * sinR + (double)data.targetHeight * cosR;
                    double x4T = -((double)data.targetHeight * sinR);
                    double y4T = (double)data.targetHeight * cosR;
                    double maxX = Math.max(x4T, Math.max(x3T, Math.max(x1T, x2T)));
                    double minX = Math.min(x4T, Math.min(x3T, Math.min(x1T, x2T)));
                    double maxY = Math.max(y4T, Math.max(y3T, Math.max(y1T, y2T)));
                    double minY = Math.min(y4T, Math.min(y3T, Math.min(y1T, y2T)));
                    targetWidth = (int)Math.floor(maxX - minX);
                    targetHeight = (int)Math.floor(maxY - minY);
                }
            }
            if (exifOrientation != 0) {
                int exifRotation = BitmapHunter.getExifRotation(exifOrientation);
                int exifTranslation = BitmapHunter.getExifTranslation(exifOrientation);
                if (exifRotation != 0) {
                    matrix.preRotate((float)exifRotation);
                    if (exifRotation == 90 || exifRotation == 270) {
                        int tmpHeight = targetHeight;
                        targetHeight = targetWidth;
                        targetWidth = tmpHeight;
                    }
                }
                if (exifTranslation != 1) {
                    matrix.postScale((float)exifTranslation, 1.0f);
                }
            }
            if (data.centerCrop) {
                float scaleY;
                float scaleX;
                float heightRatio;
                float widthRatio = targetWidth != 0 ? (float)targetWidth / (float)inWidth : (float)targetHeight / (float)inHeight;
                float f = heightRatio = targetHeight != 0 ? (float)targetHeight / (float)inHeight : (float)targetWidth / (float)inWidth;
                if (widthRatio > heightRatio) {
                    int newSize = (int)Math.ceil((float)inHeight * (heightRatio / widthRatio));
                    drawY = (data.centerCropGravity & 0x30) == 48 ? 0 : ((data.centerCropGravity & 0x50) == 80 ? inHeight - newSize : (inHeight - newSize) / 2);
                    drawHeight = newSize;
                    scaleX = widthRatio;
                    scaleY = (float)targetHeight / (float)drawHeight;
                } else if (widthRatio < heightRatio) {
                    int newSize = (int)Math.ceil((float)inWidth * (widthRatio / heightRatio));
                    drawX = (data.centerCropGravity & 3) == 3 ? 0 : ((data.centerCropGravity & 5) == 5 ? inWidth - newSize : (inWidth - newSize) / 2);
                    drawWidth = newSize;
                    scaleX = (float)targetWidth / (float)drawWidth;
                    scaleY = heightRatio;
                } else {
                    drawX = 0;
                    drawWidth = inWidth;
                    scaleX = scaleY = heightRatio;
                }
                if (BitmapHunter.shouldResize(onlyScaleDown, inWidth, inHeight, targetWidth, targetHeight)) {
                    matrix.preScale(scaleX, scaleY);
                }
            } else if (data.centerInside) {
                float scale;
                float widthRatio = targetWidth != 0 ? (float)targetWidth / (float)inWidth : (float)targetHeight / (float)inHeight;
                float heightRatio = targetHeight != 0 ? (float)targetHeight / (float)inHeight : (float)targetWidth / (float)inWidth;
                float f = scale = widthRatio < heightRatio ? widthRatio : heightRatio;
                if (BitmapHunter.shouldResize(onlyScaleDown, inWidth, inHeight, targetWidth, targetHeight)) {
                    matrix.preScale(scale, scale);
                }
            } else if (!(targetWidth == 0 && targetHeight == 0 || targetWidth == inWidth && targetHeight == inHeight)) {
                float sy;
                float sx = targetWidth != 0 ? (float)targetWidth / (float)inWidth : (float)targetHeight / (float)inHeight;
                float f = sy = targetHeight != 0 ? (float)targetHeight / (float)inHeight : (float)targetWidth / (float)inWidth;
                if (BitmapHunter.shouldResize(onlyScaleDown, inWidth, inHeight, targetWidth, targetHeight)) {
                    matrix.preScale(sx, sy);
                }
            }
        }
        if ((newResult = Bitmap.createBitmap((Bitmap)result, (int)drawX, (int)drawY, (int)drawWidth, (int)drawHeight, (Matrix)matrix, (boolean)true)) != result) {
            result.recycle();
            result = newResult;
        }
        return result;
    }

    private static boolean shouldResize(boolean onlyScaleDown, int inWidth, int inHeight, int targetWidth, int targetHeight) {
        return !onlyScaleDown || targetWidth != 0 && inWidth > targetWidth || targetHeight != 0 && inHeight > targetHeight;
    }

    static int getExifRotation(int orientation) {
        int rotation;
        switch (orientation) {
            case 5: 
            case 6: {
                rotation = 90;
                break;
            }
            case 3: 
            case 4: {
                rotation = 180;
                break;
            }
            case 7: 
            case 8: {
                rotation = 270;
                break;
            }
            default: {
                rotation = 0;
            }
        }
        return rotation;
    }

    static int getExifTranslation(int orientation) {
        int translation;
        switch (orientation) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                translation = -1;
                break;
            }
            default: {
                translation = 1;
            }
        }
        return translation;
    }
}

