package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

/**
 * Created by shayl on 7/22/2015.
 */
public class FilesTable implements BaseTable {

    private static final String TAG = FilesTable.class.getSimpleName();

    //Messages table name
    public static final String FILES_TABLE = "files";

    //Messages table columns
    public static final String KEY_ID_AS_VALUE = "file_row_id";
    public static final String KEY_PREVIEW = "preview";
    public static final String KEY_SWIFT_PATH = "swiftPath";
    public static final String KEY_FILE_TYPE = "fileType";
    public static final String KEY_LOCAL_URL = "localUrl";
    public static final String KEY_LOAD_STATUS = "loadStatus";
    public static final String KEY_RELATED_MESSAGE_ROW_ID = "relatedMessageRowID";
	public static final String KEY_LOCAL_URL_UPDATE_TIMESTAMP = "localUrlTimestamp";

	public enum LoadStatus{NOT_STARTED, PROCESSING, REQUESTING_URL, UPLOADING, DOWNLOADING, COMPLETED, FAILED, PREVIEW_ERROR}

    @Override
    public String getCreateCommand() {
        return new StringBuilder()
                .append("create table ").append(FILES_TABLE).append("(")
                .append(KEY_ID).append(" integer primary key autoincrement,")
                .append(KEY_PREVIEW).append(" text,")
                .append(KEY_SWIFT_PATH).append(" text,")
                .append(KEY_FILE_TYPE).append(" text,")
                .append(KEY_LOCAL_URL).append(" text,")
                .append(KEY_LOAD_STATUS).append(" integer,")
				.append(KEY_LOCAL_URL_UPDATE_TIMESTAMP).append(" big int,")
				.append(KEY_RELATED_MESSAGE_ROW_ID).append(" integer default -1);")
                .toString();
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        //TODO: Currently we drop the existing table, and create a new one
        //TODO: need to handle data migration when we will be in production
        if (oldVersion < 4){
            //Files table was added in version 4
            db.execSQL(getCreateCommand());
        }
    }

    @Override
    public String getName() {
        return TAG;
    }

    public static String[] getProjection() {
        return new String[]{KEY_ID, KEY_PREVIEW, KEY_SWIFT_PATH, KEY_FILE_TYPE, KEY_LOCAL_URL, KEY_RELATED_MESSAGE_ROW_ID};
    }
}