package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

import com.liveperson.infra.log.LPMobileLog;

/**
 * Created by shayl on 7/22/2015.
 */
public class MessagesTable implements BaseTable {

    private static final String TAG = MessagesTable.class.getSimpleName();

    //Messages table name
    public static final String MESSAGES_TABLE = "messages";

    //Messages table columns
    public static final String KEY_SERVER_SEQUENCE = "serverSequence";
    public static final String KEY_TEXT = "text";
    public static final String KEY_CONTENT_TYPE = "contentType";
    public static final String KEY_STATUS = "status";
    public static final String KEY_DIALOG_ID = "dialogId";
    public static final String KEY_MESSAGE_TYPE = "type";
    public static final String KEY_TIMESTAMP = "timeStamp";
    public static final String KEY_ORIGINATOR_ID = "originatorId";
    public static final String KEY_EVENT_ID = "eventId";
    public static final String KEY_ENCRYPTION_VERSION = "encryptVer";
    public static final String ENCRYPTION_VERSION_CURSOR_AS_VALUE = "message_encryptVer";

	@Override
	public String getName() {
		return TAG;
	}

	@Override
    public String getCreateCommand() {
        return new StringBuilder()
                .append("create table ").append(MESSAGES_TABLE).append("(")
                .append(KEY_ID).append(" integer primary key autoincrement,")
                .append(KEY_EVENT_ID).append(" text UNIQUE,")
                .append(KEY_SERVER_SEQUENCE).append(" integer,")
                .append(KEY_DIALOG_ID).append(" text,")
                .append(KEY_TEXT).append(" text not null,")
                .append(KEY_CONTENT_TYPE).append(" text not null,")
                .append(KEY_MESSAGE_TYPE).append(" integer not null,")
                .append(KEY_STATUS).append(" integer not null,")
                .append(KEY_ORIGINATOR_ID).append(" text,")
                .append(KEY_TIMESTAMP).append(" big int not null,")
                .append(KEY_ENCRYPTION_VERSION).append(" integer not null")
                .append(");")
                .toString();
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		if (oldVersion < 6) {
			long startTime = System.currentTimeMillis();
			String tempTableName = "messagesOld";
			//rename exists table to <tempTableName>
			db.execSQL("ALTER TABLE " + MESSAGES_TABLE + " RENAME TO " + tempTableName);
			//create msg table
			db.execSQL(getCreateCommand());

			//copy from old to new
			db.execSQL("insert into " + MESSAGES_TABLE +
					" (" + KEY_EVENT_ID +
					", " + KEY_SERVER_SEQUENCE +
					", " + KEY_DIALOG_ID +
					", " + KEY_TEXT +
					", " + KEY_CONTENT_TYPE +
					", " + KEY_MESSAGE_TYPE +
					", " + KEY_STATUS +
					", " + KEY_ORIGINATOR_ID +
					", " + KEY_TIMESTAMP +
					", " + KEY_ENCRYPTION_VERSION +
					") " +
					"select cast(" + KEY_ID + " as text) " +
					", " + KEY_SERVER_SEQUENCE +
					", convID" +
					", " + KEY_TEXT +
					", " + KEY_CONTENT_TYPE +
					", " + KEY_MESSAGE_TYPE +
					", " + KEY_STATUS +
					", " + KEY_ORIGINATOR_ID +
					", " + KEY_TIMESTAMP +
					", " + KEY_ENCRYPTION_VERSION +
					" from " + tempTableName);

			//remove old
			db.execSQL("DROP TABLE " + tempTableName);

			LPMobileLog.d(TAG, "Finished upgrading Messages table total time = " + (System.currentTimeMillis() - startTime));
		}
	}

    public static String[] getProjection() {
        return new String[]{KEY_ID, KEY_SERVER_SEQUENCE, KEY_DIALOG_ID, KEY_TEXT, KEY_CONTENT_TYPE, KEY_MESSAGE_TYPE, KEY_STATUS, KEY_EVENT_ID, KEY_ORIGINATOR_ID, KEY_TIMESTAMP, KEY_ENCRYPTION_VERSION};
    }
}