package com.liveperson.infra.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;

/**
 * Created by Yanda on 04/23/2019.
 * <p>
 * Class for quick reply item.
 */
public final class MessageOption implements Parcelable {

    private String displayText;
    private String value;

    /**
     * @param displayText Text displayed in the quick reply button.
     * @param value       Text send to agent after select the quick reply.
     */
    public MessageOption(@NonNull String displayText, @NonNull String value) {
        this.displayText = displayText;
        if (value.trim().length() == 0) {
            this.value = displayText;
        } else {
            this.value = value;
        }
    }

    public String getDisplayText() {
        return displayText;
    }

    public String getValue() {
        return value;
    }

    protected MessageOption(Parcel in) {
        displayText = in.readString();
        value = in.readString();
    }

    public static final Creator CREATOR = new Creator() {
        @Override
        public MessageOption createFromParcel(Parcel in) {
            return new MessageOption(in);
        }

        @Override
        public MessageOption[] newArray(int size) {
            return new MessageOption[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(displayText);
        dest.writeString(value);
    }
}
