/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra;

import android.os.Bundle;
import android.text.TextUtils;
import com.liveperson.infra.ForegroundServiceInterface;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.LocalBroadcast;
import java.util.HashSet;

public class ForegroundService
implements ShutDown,
ForegroundServiceInterface {
    private static final String TAG = ForegroundService.class.getSimpleName();
    public static final String SCREEN_FOREGROUND_ACTION = "SCREEN_FOREGROUND_ACTION";
    public static final String SCREEN_FOREGROUND_EXTRA_BRAND_ID = "brand_id";
    public static final String SCREEN_FOREGROUND_EXTRA_TARGET_ID = "target_id";
    public static final String SCREEN_FOREGROUND_EXTRA_IS_FOREGROUND = "is_foreground";
    private HashSet<String> mForegroundBrands = new HashSet();
    private HashSet<String> mForegroundTargets = new HashSet();
    private static volatile ForegroundService Instance = null;

    private ForegroundService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ForegroundService getInstance() {
        if (Instance != null) return Instance;
        Class<ForegroundService> clazz = ForegroundService.class;
        synchronized (ForegroundService.class) {
            if (Instance != null) return Instance;
            Instance = new ForegroundService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Instance;
        }
    }

    @Override
    public void register(String brandId, String targetId) {
        LPMobileLog.i(TAG, "register with brand " + brandId);
        boolean needBroadcast = false;
        if (!TextUtils.isEmpty((CharSequence)targetId) && !this.mForegroundTargets.contains(targetId)) {
            this.mForegroundTargets.add(targetId);
            needBroadcast = true;
        }
        if (!TextUtils.isEmpty((CharSequence)brandId) && !this.mForegroundBrands.contains(brandId)) {
            this.mForegroundBrands.add(brandId);
            needBroadcast = true;
        }
        if (needBroadcast) {
            Bundle bundle = new Bundle();
            bundle.putString(SCREEN_FOREGROUND_EXTRA_BRAND_ID, brandId);
            bundle.putString(SCREEN_FOREGROUND_EXTRA_TARGET_ID, targetId);
            bundle.putBoolean(SCREEN_FOREGROUND_EXTRA_IS_FOREGROUND, true);
            LocalBroadcast.sendBroadcast(SCREEN_FOREGROUND_ACTION, bundle);
        }
    }

    @Override
    public void unregisterBrand(String brandId) {
        LPMobileLog.i(TAG, "unregister with brand " + brandId);
        if (!TextUtils.isEmpty((CharSequence)brandId) && this.mForegroundBrands.contains(brandId)) {
            this.mForegroundBrands.remove(brandId);
            Bundle bundle = new Bundle();
            bundle.putString(SCREEN_FOREGROUND_EXTRA_BRAND_ID, brandId);
            bundle.putBoolean(SCREEN_FOREGROUND_EXTRA_IS_FOREGROUND, false);
            LocalBroadcast.sendBroadcast(SCREEN_FOREGROUND_ACTION, bundle);
        }
    }

    @Override
    public void unregisterAll() {
        for (String brand : this.mForegroundBrands) {
            this.unregisterBrand(brand);
        }
        for (String target : this.mForegroundTargets) {
            this.unregisterBrand(target);
        }
        this.mForegroundBrands.clear();
    }

    public void restart() {
        HashSet tempForegroundBrands = (HashSet)this.mForegroundBrands.clone();
        this.mForegroundBrands.clear();
        for (String brand : tempForegroundBrands) {
            this.register(brand, null);
        }
    }

    @Override
    public void unregisterTarget(String targetId) {
        LPMobileLog.i(TAG, "unregister with target " + targetId);
        if (!TextUtils.isEmpty((CharSequence)targetId) && this.mForegroundTargets.contains(targetId)) {
            this.mForegroundTargets.remove(targetId);
        }
    }

    @Override
    public boolean isBrandForeground() {
        return !this.mForegroundBrands.isEmpty();
    }

    @Override
    public boolean isBrandForeground(String brandId) {
        return this.mForegroundBrands.contains(brandId);
    }

    @Override
    public boolean isTargetForeground(String brandId) {
        return this.mForegroundTargets.contains(brandId);
    }

    @Override
    public HashSet<String> getForegroundBrandId() {
        return this.mForegroundBrands;
    }

    @Override
    public void shutDown() {
        this.unregisterAll();
    }
}

