/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.database.tables.BaseTable;
import com.liveperson.infra.database.tables.BrandProfileTable;
import com.liveperson.infra.database.tables.ConversationsTable;
import com.liveperson.infra.database.tables.DialogsTable;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.database.tables.MessagesTable;
import com.liveperson.infra.database.tables.UsersTable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import java.util.ArrayList;
import java.util.List;

public class DatabaseManager
implements ShutDown,
Clearable {
    private static final String TAG = DatabaseManager.class.getSimpleName();
    private static final String DATABASE_NAME = "lp_infra_tables.db";
    private static final int DATABASE_VERSION = 6;
    private final MessagesTable mMessagesTable;
    private final DialogsTable mDialogsTable;
    private final ConversationsTable mConversationsTable;
    private final BrandProfileTable brandProfileTable;
    private final UsersTable mUsersTable;
    private final DatabaseHelper mDBHelper;
    private static DatabaseManager mInstance = null;
    private List<BaseTable> tableList = new ArrayList<BaseTable>();

    private DatabaseManager() {
        this.mDBHelper = new DatabaseHelper(DATABASE_NAME, 6);
        this.mMessagesTable = new MessagesTable();
        this.mDialogsTable = new DialogsTable();
        this.mConversationsTable = new ConversationsTable();
        this.brandProfileTable = new BrandProfileTable();
        this.mUsersTable = new UsersTable();
        FilesTable mFilesTable = new FilesTable();
        this.registerTable(this.mMessagesTable);
        this.registerTable(this.mDialogsTable);
        this.registerTable(this.mConversationsTable);
        this.registerTable(this.brandProfileTable);
        this.registerTable(this.mUsersTable);
        this.registerTable(mFilesTable);
        this.mDBHelper.getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<DatabaseManager> clazz = DatabaseManager.class;
        synchronized (DatabaseManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DatabaseManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    DatabaseHelper getDBHelper() {
        return this.mDBHelper;
    }

    public void registerTable(@NonNull BaseTable table) {
        this.tableList.add(table);
    }

    @Override
    public void clear() {
        LPMobileLog.d(TAG, "removing db");
        Infra.instance.getApplicationContext().deleteDatabase(DATABASE_NAME);
        mInstance = null;
    }

    @Override
    public void shutDown() {
        DataBaseExecutor.killAll(new ICallback<Void, Exception>(){

            @Override
            public void onSuccess(Void value) {
                DatabaseManager.this.mDBHelper.close();
                LPMobileLog.i(TAG, "closed db.");
            }

            @Override
            public void onError(Exception exception) {
                DatabaseManager.this.mDBHelper.close();
                LPMobileLog.i(TAG, "closed db.");
            }
        });
    }

    class DatabaseHelper
    extends SQLiteOpenHelper {
        private final String TAG;

        private DatabaseHelper(String dbName, int version) {
            super(Infra.instance.getApplicationContext(), dbName, null, version);
            this.TAG = DatabaseHelper.class.getSimpleName();
            LPMobileLog.i(this.TAG, "initializing db...");
        }

        public void onCreate(SQLiteDatabase db) {
            for (BaseTable table : DatabaseManager.this.tableList) {
                LPMobileLog.d(this.TAG, "Creating table " + table.getName());
                db.execSQL(table.getCreateCommand());
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            LPMobileLog.d(this.TAG, "Upgrading DB oldVersion = " + oldVersion + " newVersion = " + newVersion);
            for (BaseTable table : DatabaseManager.this.tableList) {
                LPMobileLog.d(this.TAG, "Upgrading table " + table.getName());
                table.onTableUpgrade(db, oldVersion, newVersion);
            }
        }
    }
}

