/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.log;

import com.liveperson.infra.Infra;
import com.liveperson.infra.log.DefaultAndroidLogger;
import com.liveperson.infra.log.ILogger;
import com.liveperson.infra.log.logreporter.loggos.Loggos;
import com.liveperson.infra.log.logreporter.loggos.LoggosMessage;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LPMobileLog {
    private static final String TAG = "Liveperson";
    private static boolean DEBUG = true;
    private static boolean isLoggosEnabled = true;
    private static final String LOGGOS_CONTEXT = "AndroidSdk";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static ILogger logger = new DefaultAndroidLogger();

    public static void setLogger(ILogger logger) {
        LPMobileLog.logger = logger;
    }

    public static void setLoggosEnabled(boolean enabled) {
        isLoggosEnabled = enabled;
    }

    public static void setDebugMode(boolean debugMode) {
        DEBUG = debugMode;
    }

    public static void d(String classTAG, String logMessage) {
        if (DEBUG) {
            logger.d("Liveperson **" + classTAG + "**", logMessage);
        }
    }

    public static void d(String classTAG, String flowTag, String string2) {
        LPMobileLog.d(classTAG, "--" + flowTag + "-- " + string2);
    }

    public static void i(String classTAG, String flowTag, String string2) {
        LPMobileLog.i(classTAG, "--" + flowTag + "-- " + string2);
    }

    public static void i(String classTAG, String string2) {
        if (DEBUG) {
            logger.i("Liveperson **" + classTAG + "**", string2);
        }
        LPMobileLog.addToLoggos(classTAG, string2, INFO);
    }

    public static void w(String classTAG, String string2) {
        if (DEBUG) {
            logger.w("Liveperson **" + classTAG + "**", string2);
        }
        LPMobileLog.addToLoggos(classTAG, string2, WARN);
    }

    public static void w(String classTAG, Throwable t) {
        if (DEBUG) {
            logger.w("Liveperson **" + classTAG + "**", "WARN " + t.getMessage());
        }
        LPMobileLog.addToLoggos(classTAG, LPMobileLog.getStackTrace(t), WARN);
    }

    public static void e(String classTAG, String errorMessage) {
        logger.e("Liveperson **" + classTAG + "**", errorMessage);
        LPMobileLog.sendToLoggosNow(classTAG, errorMessage, ERROR);
    }

    public static void e(String classTAG, Throwable error) {
        LPMobileLog.e(classTAG, null, error);
    }

    public static void e(String classTAG, String flowTag, String errorMessage) {
        LPMobileLog.e(classTAG, "--" + flowTag + "-- " + errorMessage);
    }

    public static void e(String classTAG, String errorMessage, Throwable error) {
        if (errorMessage != null) {
            logger.e("Liveperson **" + classTAG + "**", errorMessage);
        }
        error.printStackTrace();
        LPMobileLog.sendToLoggosNow(classTAG, LPMobileLog.getStackTrace(error), ERROR);
    }

    private static String getStackTrace(Throwable aThrowable) {
        if (aThrowable == null) {
            return "";
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private static void addToLoggos(String classTAG, String message, String level) {
        if (isLoggosEnabled) {
            LoggosMessage loggosMessage = new LoggosMessage(level, LOGGOS_CONTEXT, message, classTAG);
            Loggos loggos = Infra.instance.getLoggos();
            if (loggos != null) {
                loggos.addMessage(loggosMessage);
            }
        }
    }

    private static void sendToLoggosNow(String classTAG, String message, String level) {
        if (isLoggosEnabled) {
            LoggosMessage loggosMessage = new LoggosMessage(level, LOGGOS_CONTEXT, message, classTAG);
            Loggos loggos = Infra.instance.getLoggos();
            if (loggos != null) {
                loggos.sendMessageImmediately(loggosMessage);
            }
        }
    }

    public class FlowTags {
        public static final String DIALOGS = "MULTI_DIALOG_FLOW";
        public static final String LOGIN = "LOGIN_FLOW";
        public static final String DECRYPTION = "DECRYPTION";
    }
}

