/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.sdkstatemachine;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.sdkstatemachine.BaseInfraState;
import com.liveperson.infra.sdkstatemachine.events.InitEvent;
import com.liveperson.infra.sdkstatemachine.events.LogoutEvent;
import com.liveperson.infra.sdkstatemachine.events.PreLogoutCompletedEvent;
import com.liveperson.infra.sdkstatemachine.events.ShutDownCompletedEvent;
import com.liveperson.infra.sdkstatemachine.events.ShutDownEvent;
import com.liveperson.infra.sdkstatemachine.logout.PreLogoutCompletionListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.BaseStateMachine;
import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;
import com.liveperson.infra.statemachine.interfaces.IEvent;

public class InfraStateMachine
extends BaseStateMachine {
    private static final String TAG = InfraStateMachine.class.getSimpleName();
    private final Idle mIdleState = new Idle("IdleState", TAG + "_Idle");
    private final Initialized mInitializedState = new Initialized("Initialized", TAG);
    private final Initializing mInitializingState = new Initializing("Initializing", TAG);
    private final ShuttingDown mShuttingDown = new ShuttingDown("ShuttingDown", TAG);
    private final Logout mLoggingOutState = new Logout("Logout", TAG);

    public InfraStateMachine() {
        super(TAG);
        this.initActiveState(this.mIdleState);
    }

    public void initSDK(InitProcess initProcess) {
        if (initProcess == null) {
            LPMobileLog.e(TAG, "getInitProcess() is null!! error!");
            return;
        }
        this.postEvent(new InitEvent(initProcess));
    }

    public void shutDownSDK(ShutDownProcess shutDownProcess) {
        if (shutDownProcess == null) {
            LPMobileLog.e(TAG, "getInitProcess() is null!! error!");
            return;
        }
        this.postEvent(new ShutDownEvent(shutDownProcess));
    }

    public void logoutSDK(LogoutProcess logoutProcess) {
        if (logoutProcess == null) {
            LPMobileLog.e(TAG, "logoutProcess is null!! error!");
            return;
        }
        this.postEvent(new LogoutEvent(logoutProcess));
    }

    public boolean isSDKInitialized() {
        return this.activeState() != null && this.activeState().equals(this.mInitializedState);
    }

    abstract class InProgressState
    extends BaseInfraState {
        LogoutEvent logoutEventWaiting;

        public InProgressState(String name, String logTag) {
            super(name, logTag);
            this.logoutEventWaiting = null;
        }

        @Override
        public void actionOnEntry() {
            this.logoutEventWaiting = null;
        }

        @Override
        public void visit(InitEvent initEvent) {
            if (this.logoutEventWaiting != null) {
                this.logoutEventWaiting.setInitAfterLogout(initEvent);
                LPMobileLog.d(this.TAG, "Logout event waiting, init after logout is NOT null ");
            }
        }

        @Override
        public void visit(ShutDownEvent shutDownEvent) {
            if (this.logoutEventWaiting != null) {
                this.logoutEventWaiting.setInitAfterLogout(null);
                LPMobileLog.d(this.TAG, "Logout event waiting, init after logout is null ");
            }
        }

        @Override
        public void visit(LogoutEvent logoutEvent) {
            this.logoutEventWaiting = logoutEvent;
            this.logoutEventWaiting.setInitAfterLogout(null);
            LPMobileLog.d(this.TAG, "Logout event waiting, init after logout is null ");
        }
    }

    class Logout
    extends BaseInfraState {
        private InitEvent mInitEventAfterLogout;
        private LogoutEvent mLogoutEvent;

        @Override
        public void actionOnEntry() {
            super.actionOnEntry();
            this.mInitEventAfterLogout = null;
            this.mLogoutEvent = null;
        }

        public Logout(String name, String logTag) {
            super(name, logTag);
            this.mInitEventAfterLogout = null;
        }

        @Override
        public void visit(LogoutEvent logoutEvent) {
            if (this.mLogoutEvent == null) {
                this.mLogoutEvent = logoutEvent;
                this.mInitEventAfterLogout = logoutEvent.getInitEvent();
                this.logout();
            } else {
                LPMobileLog.d(this.TAG, "got logout event while processing logout.. ignoring event");
            }
        }

        @Override
        public void visit(InitEvent initEvent) {
            this.mInitEventAfterLogout = initEvent;
        }

        @Override
        public void visit(ShutDownEvent shutDownEvent) {
            this.mInitEventAfterLogout = null;
        }

        @Override
        public void visit(PreLogoutCompletedEvent preLogoutCompletedEvent) {
            LPMobileLog.d(this.TAG, "shutDownForLogout...");
            LogoutProcess logoutProcess = this.mLogoutEvent.getLogoutProcess();
            logoutProcess.shutDownForLogout(new ShutDownCompletionListener(){

                @Override
                public void shutDownCompleted() {
                    InfraStateMachine.this.postEvent(new ShutDownCompletedEvent());
                }

                @Override
                public void shutDownFailed() {
                }
            });
        }

        @Override
        public void visit(ShutDownCompletedEvent shutDownCompletedEvent) {
            LPMobileLog.d(this.TAG, "logout...");
            LogoutProcess logoutProcess = this.mLogoutEvent.getLogoutProcess();
            logoutProcess.logout();
            this.onLogoutSucceed(logoutProcess);
        }

        private void logout() {
            LPMobileLog.d(this.TAG, "Stating logout process...");
            final LogoutProcess logoutProcess = this.mLogoutEvent.getLogoutProcess();
            try {
                if (!this.mLogoutEvent.skipInit()) {
                    LPMobileLog.d(this.TAG, "initForLogout...");
                    logoutProcess.initForLogout();
                }
                LPMobileLog.d(this.TAG, "preLogout...");
                logoutProcess.preLogout(new PreLogoutCompletionListener(){

                    @Override
                    public void preLogoutCompleted() {
                        InfraStateMachine.this.postEvent(new PreLogoutCompletedEvent());
                    }

                    @Override
                    public void preLogoutFailed(Exception e) {
                        LPMobileLog.w(Logout.this.TAG, "error while preLogoutFailed: " + e.getMessage());
                        Logout.this.onLogoutFailed(e, logoutProcess);
                    }
                });
            }
            catch (Exception e) {
                LPMobileLog.w(this.TAG, "error while logout: " + e.getMessage());
                this.onLogoutFailed(e, logoutProcess);
            }
        }

        private void onLogoutSucceed(LogoutProcess logoutProcess) {
            logoutProcess.getLogoutCallback().onLogoutSucceed();
            this.exitState();
        }

        private void onLogoutFailed(Exception e, LogoutProcess logoutProcess) {
            logoutProcess.getLogoutCallback().onLogoutFailed(e);
            this.exitState();
        }

        private void exitState() {
            if (this.mInitEventAfterLogout != null) {
                InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mIdleState, (IEvent)this.mInitEventAfterLogout);
            } else {
                InfraStateMachine.this.changeState(InfraStateMachine.this.mIdleState);
            }
        }
    }

    class ShuttingDown
    extends InProgressState {
        private ShutDownProcess mShutDownProcess;
        private InitEvent mInitEventAfterShutDown;

        public ShuttingDown(String name, String logTag) {
            super(name, logTag);
            this.mShutDownProcess = null;
            this.mInitEventAfterShutDown = null;
        }

        @Override
        public void actionOnEntry() {
            super.actionOnEntry();
            this.mShutDownProcess = null;
            this.mInitEventAfterShutDown = null;
        }

        @Override
        public void visit(ShutDownEvent shutDownEvent) {
            super.visit(shutDownEvent);
            if (this.mShutDownProcess == null) {
                this.mShutDownProcess = shutDownEvent.getInitProcess();
                this.mShutDownProcess.shutDown(new ShutDownCompletionListener(){

                    @Override
                    public void shutDownCompleted() {
                        InfraStateMachine.this.postEvent(new ShutDownCompletedEvent());
                    }

                    @Override
                    public void shutDownFailed() {
                    }
                });
            } else {
                LPMobileLog.d(this.TAG, "got shutDown event while processing Shutting Down... removing waiting init event if exists.");
                this.mInitEventAfterShutDown = null;
            }
        }

        @Override
        public void visit(ShutDownCompletedEvent shutDownCompletedEvent) {
            LPMobileLog.d(this.TAG, "Shut down finished successfully! :) ");
            this.mShutDownProcess.getShutDownCallback().onShutDownSucceed();
            if (this.logoutEventWaiting != null) {
                LPMobileLog.d(this.TAG, "Logout event waiting, logging out...");
                InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mLoggingOutState, (IEvent)this.logoutEventWaiting);
            } else if (this.mInitEventAfterShutDown != null) {
                LPMobileLog.d(this.TAG, "Init event waiting, moving to initialized...");
                InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mInitializingState, (IEvent)this.mInitEventAfterShutDown);
            } else {
                InfraStateMachine.this.changeState(InfraStateMachine.this.mIdleState);
            }
        }

        @Override
        public void visit(InitEvent initEvent) {
            super.visit(initEvent);
            LPMobileLog.d(this.TAG, "got init event while processing Shutting Down...");
            this.mInitEventAfterShutDown = initEvent;
        }

        @Override
        public void visit(LogoutEvent logoutEvent) {
            super.visit(logoutEvent);
            LPMobileLog.d(this.TAG, "Got logout event while processing Shutting Down... removing init waiting event");
            this.mInitEventAfterShutDown = null;
        }
    }

    class Initialized
    extends BaseInfraState {
        public Initialized(String name, String logTag) {
            super(name, logTag);
        }

        @Override
        public void visit(InitEvent initEvent) {
            LPMobileLog.d(this.TAG, "Initialized! calling onInitSucceed callback");
            initEvent.getInitProcess().getInitCallback().onInitSucceed();
        }

        @Override
        public void visit(ShutDownEvent shutDownEvent) {
            InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mShuttingDown, (IEvent)shutDownEvent);
        }

        @Override
        public void visit(LogoutEvent logoutEvent) {
            logoutEvent.setSkipInit(true);
            InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mLoggingOutState, (IEvent)logoutEvent);
        }
    }

    class Initializing
    extends InProgressState {
        public Initializing(String name, String logTag) {
            super(name, logTag);
        }

        @Override
        public void visit(InitEvent initEvent) {
            InitProcess initProcess = initEvent.getInitProcess();
            try {
                initProcess.init();
                LPMobileLog.d(this.TAG, "Init finished Successfully! :) ");
                InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mInitializedState, (IEvent)initEvent);
            }
            catch (Exception e) {
                LPMobileLog.e(this.TAG, e);
                initProcess.getInitCallback().onInitFailed(e);
                InfraStateMachine.this.changeState(InfraStateMachine.this.mIdleState);
            }
        }
    }

    class Idle
    extends BaseInfraState {
        public Idle(String name, String logTag) {
            super(name, logTag);
        }

        @Override
        public void visit(InitEvent initEvent) {
            InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mInitializingState, (IEvent)initEvent);
        }

        @Override
        public void visit(LogoutEvent logoutEvent) {
            InfraStateMachine.this.changeStateAndPassEvent(InfraStateMachine.this.mLoggingOutState, (IEvent)logoutEvent);
        }

        @Override
        public void visit(ShutDownEvent shutDownEvent) {
            LPMobileLog.d(this.TAG, "shutDownEvent on init. ignore.");
        }
    }
}

