/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.picasso;

import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.liveperson.infra.utils.picasso.Callback;
import com.liveperson.infra.utils.picasso.RequestCreator;
import java.lang.ref.WeakReference;

class DeferredRequestCreator
implements ViewTreeObserver.OnPreDrawListener,
View.OnAttachStateChangeListener {
    private final RequestCreator creator;
    @VisibleForTesting
    final WeakReference<ImageView> target;
    @VisibleForTesting
    Callback callback;

    DeferredRequestCreator(RequestCreator creator, ImageView target, Callback callback) {
        this.creator = creator;
        this.target = new WeakReference<ImageView>(target);
        this.callback = callback;
        target.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        if (target.getWindowToken() != null) {
            this.onViewAttachedToWindow((View)target);
        }
    }

    public void onViewAttachedToWindow(View view) {
        view.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    public void onViewDetachedFromWindow(View view) {
        view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    public boolean onPreDraw() {
        ImageView target = (ImageView)this.target.get();
        if (target == null) {
            return true;
        }
        ViewTreeObserver vto = target.getViewTreeObserver();
        if (!vto.isAlive()) {
            return true;
        }
        int width = target.getWidth();
        int height = target.getHeight();
        if (width <= 0 || height <= 0) {
            return true;
        }
        target.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.target.clear();
        this.creator.unfit().resize(width, height).into(target, this.callback);
        return true;
    }

    void cancel() {
        this.creator.clearTag();
        this.callback = null;
        ImageView target = (ImageView)this.target.get();
        if (target == null) {
            return;
        }
        this.target.clear();
        target.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        ViewTreeObserver vto = target.getViewTreeObserver();
        if (vto.isAlive()) {
            vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
    }

    Object getTag() {
        return this.creator.getTag();
    }
}

