package com.liveperson.infra.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;

import com.liveperson.infra.log.LPLog;

/**
 * A broadcast receiver to listen if a headset is unplugged.
 *
 * The onUnpluggedHeadset() abstract method need to be implemented with the required action
 */
public abstract class DetectHeadsetUnpluggedBroadcastReceiver extends BroadcastReceiver {

	private static final String TAG = "DetectHeadsetUnpluggedBroadcastReceiver";

	/**
	 * Action to take when the headset is unplugged
	 */
	protected abstract void onUnpluggedHeadset();

	@Override
	public void onReceive(Context context, Intent intent) {
		if (AudioManager.ACTION_AUDIO_BECOMING_NOISY.equals(intent.getAction())) {

			LPLog.INSTANCE.d(TAG, "onReceive: headset unplugged");
			onUnpluggedHeadset();
		}
	}
}
