/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.utils;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;

import com.liveperson.infra.log.LPLog;
import com.squareup.picasso.OkHttp3Downloader;
import com.squareup.picasso.Picasso;

import okhttp3.OkHttpClient;

import static com.liveperson.infra.errors.ErrorCode.ERR_00000011;

/**
 * Created by Yanda on 2019/07/30
 * Picasso util class to enable TLSv1.2 for Android 4.4
 */
public class PicassoUtils {

    private static final String TAG = "PicassoUtils";

    private static boolean initialized;

    public static Picasso get(@NonNull Context context) {
        if (Build.VERSION.SDK_INT == Build.VERSION_CODES.KITKAT && !initialized) {
            try {
	            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
	            TlsUtil.enableTls12ForKitKat(clientBuilder);
	            Picasso picasso = new Picasso.Builder(context)
	                    .downloader(new OkHttp3Downloader(clientBuilder.build()))
	                    .build();
	            initialized = true;
                Picasso.setSingletonInstance(picasso);
            } catch (Exception e) {
	            LPLog.INSTANCE.e(TAG, ERR_00000011, "Fail to set picasso instance", e);
            }
        }
        return Picasso.get();
    }
}
