/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.text.TextUtils;
import android.util.Base64;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.R;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u001e\u001a\u00020\fH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/liveperson/infra/controller/DBEncryptionService;", "Lcom/liveperson/infra/Clearable;", "()V", "androidKeyStore", "Ljava/security/KeyStore;", "dbEncryptionKey", "Ljavax/crypto/SecretKey;", "legacyIvSpec", "Ljavax/crypto/spec/IvParameterSpec;", "onlyKeystore", "", "clear", "", "createKeystoreAESKeyIfNecessary", "decrypt", "", "cipherText", "decryptKey", "encryptedKey", "encrypt", "plainText", "encryptAndSaveKey", "decryptedKey", "generateKeyPairInStoreIfNotExists", "generateLegacyAesEncryptionKey", "getAESDecryptCipher", "Ljavax/crypto/Cipher;", "ivSpec", "getAESEncryptCipher", "loadInternalLegacyAESKey", "loadKeystore", "loadLegacyIvSpec", "setDbEncryptionKey", "key", "unpackIvSpecBytes", "base64ivSpec", "Companion", "infra_release"})
public final class DBEncryptionService
implements Clearable {
    private KeyStore androidKeyStore;
    private SecretKey dbEncryptionKey;
    private final IvParameterSpec legacyIvSpec;
    private final boolean onlyKeystore = Build.VERSION.SDK_INT >= 23 && !PreferenceManager.getInstance().contains("dbEncryptionKey", "appLevelPreferences");
    private static final String TAG = "DBEncryptionService";
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    private static final String DB_ENCRYPTION_KEY = "dbEncryptionKey";
    private static final String DB_ENCRYPTION_USES_KEYSTORE = "dbEncryptionUsesKeyStore";
    private static final String ANDROID_INFRA_DB_ENC_KEY = "androidInfraDbEncKey";
    private static final String DB_ENC_CN = "CN=DBKeyEncryptor, O=Liveperson";
    private static final String TRANSFORMATION_RSA = "RSA/ECB/PKCS1Padding";
    private static final String TRANSFORMATION_AES_PKCS5Padding = "AES/CBC/PKCS5Padding";
    private static final String TRANSFORMATION_AES_PKCS7Padding = "AES/CBC/PKCS7Padding";
    private static final String INITIALIZATION_VECTOR = "initializationVector";
    private static final String IV_SEPARATOR = "::";
    public static final Companion Companion = new Companion(null);

    private final void loadKeystore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEYSTORE);
            Intrinsics.checkExpressionValueIsNotNull((Object)keyStore, (String)"KeyStore.getInstance(\"AndroidKeyStore\")");
            KeyStore keyStore2 = this.androidKeyStore = keyStore;
            if (keyStore2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            keyStore2.load(null, null);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000034, "Failed to load Keystore.", e);
        }
    }

    private final IvParameterSpec loadLegacyIvSpec() {
        String initializationVectorFromSharedPrefs = PreferenceManager.getInstance().getStringValue(INITIALIZATION_VECTOR, "appLevelPreferences", null);
        if (initializationVectorFromSharedPrefs != null) {
            LPLog.INSTANCE.w(TAG, "Found a legacy Initialization Vector; loading it. Please log out and back in to clear old data.");
            return new IvParameterSpec(Base64.decode((String)initializationVectorFromSharedPrefs, (int)0));
        }
        return null;
    }

    private final IvParameterSpec unpackIvSpecBytes(String base64ivSpec) {
        return new IvParameterSpec(Base64.decode((String)base64ivSpec, (int)0));
    }

    private final String loadInternalLegacyAESKey() {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        String encryptionKey = null;
        String encryptedEncryptionKeyFromSharedPrefs = PreferenceManager.getInstance().getStringValue(DB_ENCRYPTION_KEY, "appLevelPreferences", null);
        try {
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            KeyStore.Entry entry = keyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            if (entry == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.PrivateKeyEntry");
            }
            privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
        }
        catch (Exception e) {
            privateKeyEntry = null;
        }
        KeyStore.PrivateKeyEntry privateKeyEntryForValidation = privateKeyEntry;
        if (encryptedEncryptionKeyFromSharedPrefs == null || privateKeyEntryForValidation == null) {
            encryptionKey = this.generateLegacyAesEncryptionKey();
            this.encryptAndSaveKey(encryptionKey);
        } else if (PreferenceManager.getInstance().getBooleanValue(DB_ENCRYPTION_USES_KEYSTORE, "appLevelPreferences", false)) {
            encryptionKey = this.decryptKey(encryptedEncryptionKeyFromSharedPrefs);
        } else {
            encryptionKey = encryptedEncryptionKeyFromSharedPrefs;
            this.encryptAndSaveKey(encryptionKey);
        }
        return encryptionKey;
    }

    /*
     * WARNING - void declaration
     */
    private final String decryptKey(String encryptedKey) {
        String decryptedKey = null;
        try {
            int n;
            int n2;
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            KeyStore.Entry entry = keyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            if (entry == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.PrivateKeyEntry");
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            Cipher output = Cipher.getInstance(TRANSFORMATION_RSA);
            output.init(2, privateKeyEntry.getPrivateKey());
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)encryptedKey, (int)0)), output);
            ArrayList<Byte> values = new ArrayList<Byte>();
            Ref.IntRef nextByte = new Ref.IntRef();
            while (true) {
                int n3 = cipherInputStream.read();
                n2 = 0;
                n = 0;
                int it = n3;
                boolean bl = false;
                nextByte.element = it;
                if (n3 == -1) break;
                values.add((byte)nextByte.element);
            }
            byte[] bytes = new byte[values.size()];
            n2 = 0;
            n = bytes.length;
            while (n2 < n) {
                void i;
                Object e = values.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"values[i]");
                bytes[i] = ((Number)e).byteValue();
                ++i;
            }
            n2 = 0;
            n = bytes.length;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            decryptedKey = new String(bytes, n2, n, charset2);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000035, "Exception while decrypting key.", e);
        }
        return decryptedKey;
    }

    private final void encryptAndSaveKey(String decryptedKey) {
        String encryptedKey = null;
        boolean usesAndroidKeyStore = true;
        this.generateKeyPairInStoreIfNotExists();
        try {
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            KeyStore.Entry entry = keyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            if (entry == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.PrivateKeyEntry");
            }
            KeyStore.PrivateKeyEntry publicKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            Cipher input = Cipher.getInstance(TRANSFORMATION_RSA);
            Certificate certificate = publicKeyEntry.getCertificate();
            Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"publicKeyEntry.certificate");
            input.init(1, certificate.getPublicKey());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, input);
            String string2 = decryptedKey;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            CipherOutputStream cipherOutputStream2 = cipherOutputStream;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string4.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            cipherOutputStream2.write(byArray2);
            cipherOutputStream.close();
            encryptedKey = Base64.encodeToString((byte[])outputStream.toByteArray(), (int)0);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000036, "Exception while encrypting/saving key.", e);
            encryptedKey = decryptedKey;
            usesAndroidKeyStore = false;
        }
        PreferenceManager.getInstance().setStringValue(DB_ENCRYPTION_KEY, "appLevelPreferences", encryptedKey);
        PreferenceManager.getInstance().setBooleanValue(DB_ENCRYPTION_USES_KEYSTORE, "appLevelPreferences", usesAndroidKeyStore);
    }

    private final String generateLegacyAesEncryptionKey() {
        SecretKey secretKey;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey secretKey2 = keyGen.generateKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)secretKey2, (String)"keyGen.generateKey()");
            secretKey = secretKey2;
        }
        catch (NoSuchAlgorithmException noSuchAlgException) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000037, "Exception while generating AES Encryption Key", noSuchAlgException);
            byte[] randomBytes = new byte[32];
            new SecureRandom().nextBytes(randomBytes);
            String string2 = Base64.encodeToString((byte[])randomBytes, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(randomBytes, Base64.DEFAULT)");
            return string2;
        }
        SecretKey secretKey3 = secretKey;
        String string3 = Base64.encodeToString((byte[])secretKey3.getEncoded(), (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.encodeToString(se\u2026.encoded, Base64.DEFAULT)");
        return string3;
    }

    private final void generateKeyPairInStoreIfNotExists() {
        try {
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            if (!keyStore.containsAlias(ANDROID_INFRA_DB_ENC_KEY)) {
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                end.add(1, 120);
                KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
                KeyPairGeneratorSpec.Builder builder = new KeyPairGeneratorSpec.Builder(Infra.instance.getApplicationContext()).setAlias(ANDROID_INFRA_DB_ENC_KEY).setSubject(new X500Principal(DB_ENC_CN)).setSerialNumber(BigInteger.ONE);
                Calendar calendar = start;
                Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"start");
                KeyPairGeneratorSpec.Builder builder2 = builder.setStartDate(calendar.getTime());
                Calendar calendar2 = end;
                Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"end");
                generator.initialize((AlgorithmParameterSpec)builder2.setEndDate(calendar2.getTime()).build());
                generator.generateKeyPair();
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000038, "Exception while generating KeyPair.", e);
        }
    }

    private final void setDbEncryptionKey(String key) {
        byte[] decodedKey = Base64.decode((String)key, (int)0);
        byte by = decodedKey[0];
        decodedKey[0] = (byte)(by + 1);
        this.dbEncryptionKey = new SecretKeySpec(decodedKey, "AES");
    }

    @Nullable
    public final String encrypt(@Nullable String plainText) {
        if (TextUtils.isEmpty((CharSequence)plainText)) {
            return plainText;
        }
        try {
            Cipher cipher = this.getAESEncryptCipher();
            String string2 = plainText;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            Cipher cipher2 = cipher;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string4.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            byte[] encryptedBytes = cipher2.doFinal(byArray2);
            byte[] iv = cipher.getIV();
            String base64Bytes = Base64.encodeToString((byte[])encryptedBytes, (int)0);
            String base64iv = Base64.encodeToString((byte[])iv, (int)0);
            LPLog.INSTANCE.v(TAG, "Successfully Encrypted block " + LPLog.INSTANCE.mask(base64iv));
            return base64iv + IV_SEPARATOR + base64Bytes;
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000039, "Exception while Encrypting text.", e);
            return plainText;
        }
    }

    @Nullable
    public final String decrypt(@Nullable String cipherText) {
        if (TextUtils.isEmpty((CharSequence)cipherText)) {
            return cipherText;
        }
        String string2 = cipherText;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        CharSequence charSequence = string2;
        String string3 = IV_SEPARATOR;
        int n = 0;
        string3 = new Regex(string3);
        n = 0;
        boolean bl = false;
        Collection $this$toTypedArray$iv = string3.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] parts = stringArray;
        IvParameterSpec ivSpec = null;
        String messageText = null;
        if (parts.length > 1) {
            ivSpec = this.unpackIvSpecBytes(parts[0]);
            messageText = parts[1];
        } else {
            ivSpec = this.legacyIvSpec;
            messageText = parts[0];
        }
        try {
            Cipher cipher = this.getAESDecryptCipher(ivSpec);
            byte[] data = Base64.decode((String)messageText, (int)0);
            byte[] decryptedBytes = cipher.doFinal(data);
            LPLog.INSTANCE.v(TAG, "Successfully Decrypted " + (parts.length > 1 ? LPLog.INSTANCE.mask("block " + parts[0]) : "Legacy block"));
            Intrinsics.checkExpressionValueIsNotNull((Object)decryptedBytes, (String)"decryptedBytes");
            byte[] byArray = decryptedBytes;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl2 = false;
            return new String(byArray, charset2);
        }
        catch (BadPaddingException badPaddingException) {
            LPLog.INSTANCE.w(TAG, FlowTags.DECRYPTION, "Caught a bad padding exception!", badPaddingException);
            LPLog.INSTANCE.d(TAG, FlowTags.DECRYPTION, "Using fallback after BadPaddingException");
            try {
                Cipher cipher = this.getAESDecryptCipher(ivSpec);
                byte[] data = Utils.hexStringToByteArray(messageText);
                byte[] decryptedBytes = cipher.doFinal(data);
                LPLog.INSTANCE.d(TAG, FlowTags.DECRYPTION, "BadPaddingException fallback worked!");
                Intrinsics.checkExpressionValueIsNotNull((Object)decryptedBytes, (String)"decryptedBytes");
                byte[] byArray = decryptedBytes;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset3 = charset;
                boolean bl3 = false;
                return new String(byArray, charset3);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, FlowTags.DECRYPTION, ErrorCode.ERR_0000003A, "BadPaddingException fallback failed.", e);
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, FlowTags.DECRYPTION, ErrorCode.ERR_0000003B, "Caught an unexpected exception.", e);
        }
        return cipherText;
    }

    private final Cipher getAESEncryptCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, UnrecoverableEntryException, KeyStoreException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.onlyKeystore ? TRANSFORMATION_AES_PKCS7Padding : TRANSFORMATION_AES_PKCS5Padding);
        if (this.onlyKeystore) {
            this.createKeystoreAESKeyIfNecessary();
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            KeyStore.Entry entry = keyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            if (entry == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
            }
            KeyStore.SecretKeyEntry keyEntry = (KeyStore.SecretKeyEntry)entry;
            SecretKey key = keyEntry.getSecretKey();
            cipher.init(1, key);
        } else {
            cipher.init(1, (Key)this.dbEncryptionKey, this.legacyIvSpec);
        }
        Cipher cipher2 = cipher;
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher2, (String)"cipher");
        return cipher2;
    }

    private final Cipher getAESDecryptCipher(IvParameterSpec ivSpec) throws NoSuchAlgorithmException, NoSuchPaddingException, UnrecoverableEntryException, KeyStoreException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.onlyKeystore ? TRANSFORMATION_AES_PKCS7Padding : TRANSFORMATION_AES_PKCS5Padding);
        if (this.onlyKeystore) {
            this.createKeystoreAESKeyIfNecessary();
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            KeyStore.Entry entry = keyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            if (entry == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
            }
            KeyStore.SecretKeyEntry keyEntry = (KeyStore.SecretKeyEntry)entry;
            SecretKey key = keyEntry.getSecretKey();
            cipher.init(2, (Key)key, ivSpec);
        } else {
            cipher.init(2, (Key)this.dbEncryptionKey, ivSpec);
        }
        Cipher cipher2 = cipher;
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher2, (String)"cipher");
        return cipher2;
    }

    @TargetApi(value=23)
    private final void createKeystoreAESKeyIfNecessary() {
        try {
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            if (!keyStore.containsAlias(ANDROID_INFRA_DB_ENC_KEY)) {
                try {
                    KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", ANDROID_KEYSTORE);
                    KeyGenParameterSpec keyGenParameterSpec = new KeyGenParameterSpec.Builder(ANDROID_INFRA_DB_ENC_KEY, 3).setKeySize(256).setBlockModes(new String[]{"CBC"}).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build();
                    keyGenerator.init((AlgorithmParameterSpec)keyGenParameterSpec);
                    keyGenerator.generateKey();
                }
                catch (Exception e) {
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000014B, "Fatal exception while generating new AES key: ", e);
                }
            }
        }
        catch (KeyStoreException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000014A, "Fatal exception while accessing keystore: ", e);
        }
    }

    @Override
    public void clear() {
        try {
            KeyStore keyStore = this.androidKeyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"androidKeyStore");
            }
            keyStore.deleteEntry(ANDROID_INFRA_DB_ENC_KEY);
        }
        catch (Exception kse) {
            LPLog.INSTANCE.d(TAG, "exception deleting key store entry: ", kse);
        }
    }

    public DBEncryptionService() {
        LPLog.INSTANCE.i(TAG, "Using " + (this.onlyKeystore ? "Keystore" : "Legacy") + " encryption system.");
        this.loadKeystore();
        this.legacyIvSpec = this.loadLegacyIvSpec();
        if (this.onlyKeystore) {
            this.dbEncryptionKey = null;
        } else {
            this.setDbEncryptionKey(this.loadInternalLegacyAESKey());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/liveperson/infra/controller/DBEncryptionService$Companion;", "", "()V", "ANDROID_INFRA_DB_ENC_KEY", "", "ANDROID_KEYSTORE", "DB_ENCRYPTION_KEY", "DB_ENCRYPTION_USES_KEYSTORE", "DB_ENC_CN", "INITIALIZATION_VECTOR", "IV_SEPARATOR", "TAG", "TRANSFORMATION_AES_PKCS5Padding", "TRANSFORMATION_AES_PKCS7Padding", "TRANSFORMATION_RSA", "appEncryptionVersion", "Lcom/liveperson/infra/utils/EncryptionVersion;", "getAppEncryptionVersion", "()Lcom/liveperson/infra/utils/EncryptionVersion;", "infra_release"})
    public static final class Companion {
        @NotNull
        public final EncryptionVersion getAppEncryptionVersion() {
            EncryptionVersion encryptionVersion;
            try {
                EncryptionVersion encryptionVersion2 = EncryptionVersion.fromInt(Configuration.getInteger(R.integer.encryptionVersion));
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)encryptionVersion2), (String)"EncryptionVersion.fromIn\u2026teger.encryptionVersion))");
                encryptionVersion = encryptionVersion2;
            }
            catch (Resources.NotFoundException e) {
                LPLog.INSTANCE.e(DBEncryptionService.TAG, ErrorCode.ERR_0000003C, "Exception while getting app encryption version.", e);
                encryptionVersion = EncryptionVersion.VERSION_1;
            }
            return encryptionVersion;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

