/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.DispatchQueue;

public class DataBaseExecutor {
    private static final String TAG = "DataBaseExecutor";
    private static DispatchQueue mDispatchQueue;
    private static boolean isIdle;
    private static ICallback<Void, Exception> mShutDownCallback;

    private static void init() {
        if (mDispatchQueue == null) {
            mShutDownCallback = null;
            mDispatchQueue = new DispatchQueue("DataBase", () -> {
                isIdle = true;
                if (mShutDownCallback != null) {
                    DataBaseExecutor.shutDown(mShutDownCallback);
                    mShutDownCallback = null;
                }
            });
        }
    }

    public static void execute(Runnable runnable) {
        DataBaseExecutor.init();
        isIdle = false;
        if (!mDispatchQueue.isCurrentThread()) {
            mDispatchQueue.postRunnable(runnable);
        } else {
            runnable.run();
        }
    }

    public static void killAll(ICallback<Void, Exception> callback) {
        if (mDispatchQueue != null && mDispatchQueue.isAlive()) {
            LPLog.INSTANCE.d(TAG, "killing all...");
            mDispatchQueue.cleanupQueue();
            if (isIdle) {
                DataBaseExecutor.shutDown(callback);
            } else {
                mShutDownCallback = callback;
            }
        }
    }

    private static void shutDown(ICallback<Void, Exception> callback) {
        mDispatchQueue.dispose();
        mDispatchQueue = null;
        LPLog.INSTANCE.d(TAG, "kill all finished");
        callback.onSuccess(null);
    }
}

