/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PushRequest
implements Command {
    private static final String TAG = "PushRequest";
    static final String KEY_APP_ID = "appId";
    static final String KEY_USER_ID = "lpid";
    static final String KEY_PLATFORM = "platform";
    private static final String KEY_REGISTRATION_ID = "pnToken";
    private static final String KEY_DEVICE_ID = "deviceId";
    private static final String KEY_TOKEN_ID = "jwt";
    private static final String KEY_OUTBOUND_MESSAGING_SUPPORT = "outboundMessagingSupport";
    private static final String KEY_AUTH_TYPE = "authType";
    private static final String KEY_OUTBOUND_MESSAGING_RICH_CONTENT = "outboundMessagingRichContent";
    private String mDeviceId = "12345678";
    private String mGcmRegistrationId;
    String mAppId;
    private String mTokenId;
    String mUserId;
    String mPlatform;
    private String mPusherURL;
    String userAuthType;
    private List<String> mCertificates;
    @Nullable
    protected ICallback<Void, Exception> mCallback;

    public PushRequest(String pusherURL, String userId, String appId, String gcmRegistrationId, String tokenId, String platform, String authType, List<String> certificates) {
        this.mPusherURL = pusherURL;
        this.mGcmRegistrationId = gcmRegistrationId;
        this.mUserId = userId;
        this.mAppId = appId;
        this.mTokenId = tokenId;
        this.mPlatform = platform;
        this.userAuthType = authType;
        this.mCertificates = certificates;
    }

    public PushRequest setAppId(String appId) {
        this.mAppId = appId;
        return this;
    }

    public PushRequest setCallback(ICallback<Void, Exception> callback) {
        this.mCallback = callback;
        return this;
    }

    @Override
    public void execute() {
        JSONObject pusherJson = this.getBody();
        HttpPostRequest httpPostRequest = new HttpPostRequest(this.mPusherURL);
        LPJSONObjectBody jsonBody = new LPJSONObjectBody(pusherJson);
        httpPostRequest.setBody(jsonBody);
        httpPostRequest.setCertificatePinningKeys(this.mCertificates);
        LPLog.INSTANCE.i(TAG, "Pusher url " + this.mPusherURL);
        LPLog.INSTANCE.d(TAG, "pusherJson " + pusherJson.toString());
        LPLog.INSTANCE.d(TAG, "pusherJson body " + jsonBody.toString());
        httpPostRequest.setCallback(new ICallback<String, Exception>(){

            @Override
            public void onSuccess(String json) {
                PushRequest.this.handleResponse(json);
            }

            @Override
            public void onError(Exception exception) {
                PushRequest.this.handleError(exception);
            }
        });
        HttpHandler.execute(httpPostRequest);
    }

    public void handleResponse(String json) {
        block7: {
            if (!TextUtils.isEmpty((CharSequence)json)) {
                try {
                    JSONObject response = new JSONObject(json);
                    String pnToken = response.optString(KEY_REGISTRATION_ID);
                    if (!TextUtils.isEmpty((CharSequence)pnToken)) {
                        LPLog.INSTANCE.d(TAG, "onSuccess " + json);
                        if (this.mCallback != null) {
                            this.mCallback.onSuccess(null);
                        }
                        break block7;
                    }
                    String errorMsg = response.optString("message");
                    if (!TextUtils.isEmpty((CharSequence)errorMsg)) {
                        this.handleError(new Exception(errorMsg));
                        break block7;
                    }
                    this.handleError(new Exception("Empty register pusher response " + json));
                }
                catch (JSONException e) {
                    this.handleError(new Exception(json));
                }
            } else {
                this.handleError(new Exception("Empty response!"));
            }
        }
    }

    public void handleError(Exception exception) {
        if (exception != null) {
            LPLog.INSTANCE.d(TAG, "onError ", exception);
            if (this.mCallback != null) {
                this.mCallback.onError(new Exception("Failed to register to pusher. response message = ", exception));
            }
        } else if (this.mCallback != null) {
            this.mCallback.onError(new Exception("Failed to register to pusher."));
        }
    }

    @NonNull
    protected JSONObject getBody() {
        JSONObject pusherJson = new JSONObject();
        try {
            pusherJson.put(KEY_APP_ID, (Object)this.mAppId);
            pusherJson.put(KEY_USER_ID, (Object)this.mUserId);
            pusherJson.put(KEY_PLATFORM, (Object)this.mPlatform);
            pusherJson.put(KEY_REGISTRATION_ID, (Object)this.mGcmRegistrationId);
            pusherJson.put(KEY_DEVICE_ID, (Object)this.mDeviceId);
            pusherJson.put(KEY_TOKEN_ID, (Object)this.mTokenId);
            pusherJson.put(KEY_AUTH_TYPE, (Object)this.userAuthType);
            pusherJson.put(KEY_OUTBOUND_MESSAGING_SUPPORT, true);
            pusherJson.put(KEY_OUTBOUND_MESSAGING_RICH_CONTENT, true);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return pusherJson;
    }
}

