/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.text.TextUtils;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import java.util.HashMap;

public class LpColorParseUtils {
    private static final String TAG = "LpColorParseUtils";
    private static final HashMap<String, String> colorNameMap = new HashMap();

    @ColorInt
    public static Integer parseColor(String colorString) {
        if (TextUtils.isEmpty((CharSequence)colorString)) {
            return null;
        }
        Integer colorInt = null;
        try {
            if (colorString.charAt(0) == '#') {
                colorInt = Color.parseColor((String)colorString);
            } else {
                String colorName = colorString.toLowerCase();
                if (colorNameMap.containsKey(colorName)) {
                    colorInt = Color.parseColor((String)colorNameMap.get(colorName));
                }
            }
        }
        catch (IllegalArgumentException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000022, "IllegalArgumentException when parsing color: " + colorString, e);
        }
        return colorInt;
    }

    static {
        colorNameMap.put("aliceblue", "#f0f8ff");
        colorNameMap.put("antiquewhite", "#faebd7");
        colorNameMap.put("aqua", "#00ffff");
        colorNameMap.put("aquamarine", "#7fffd4");
        colorNameMap.put("azure", "#f0ffff");
        colorNameMap.put("beige", "#f5f5dc");
        colorNameMap.put("bisque", "#ffe4c4");
        colorNameMap.put("black", "#000000");
        colorNameMap.put("blanchedalmond", "#ffebcd");
        colorNameMap.put("blue", "#0000ff");
        colorNameMap.put("blueviolet", "#8a2be2");
        colorNameMap.put("brown", "#a52a2a");
        colorNameMap.put("burlywood", "#deb887");
        colorNameMap.put("cadetblue", "#5f9ea0");
        colorNameMap.put("chartreuse", "#7fff00");
        colorNameMap.put("chocolate", "#d2691e");
        colorNameMap.put("coral", "#ff7f50");
        colorNameMap.put("cornflowerblue", "#6495ed");
        colorNameMap.put("cornsilk", "#fff8dc");
        colorNameMap.put("crimson", "#dc143c");
        colorNameMap.put("cyan", "#00ffff");
        colorNameMap.put("darkblue", "#00008b");
        colorNameMap.put("darkcyan", "#008b8b");
        colorNameMap.put("darkgoldenrod", "#b8860b");
        colorNameMap.put("darkgray", "#a9a9a9");
        colorNameMap.put("darkgrey", "#a9a9a9");
        colorNameMap.put("darkgreen", "#006400");
        colorNameMap.put("darkkhaki", "#bdb76b");
        colorNameMap.put("darkmagenta", "#8b008b");
        colorNameMap.put("darkolivegreen", "#556b2f");
        colorNameMap.put("darkorange", "#ff8c00");
        colorNameMap.put("darkorchid", "#9932cc");
        colorNameMap.put("darkred", "#8b0000");
        colorNameMap.put("darksalmon", "#e9967a");
        colorNameMap.put("darkseagreen", "#8fbc8f");
        colorNameMap.put("darkslateblue", "#483d8b");
        colorNameMap.put("darkslategray", "#2f4f4f");
        colorNameMap.put("darkslategrey", "#2f4f4f");
        colorNameMap.put("darkturquoise", "#00ced1");
        colorNameMap.put("darkviolet", "#9400d3");
        colorNameMap.put("deeppink", "#ff1493");
        colorNameMap.put("deepskyblue", "#00bfff");
        colorNameMap.put("dimgray", "#696969");
        colorNameMap.put("dimgrey", "#696969");
        colorNameMap.put("dodgerblue", "#1e90ff");
        colorNameMap.put("firebrick", "#b22222");
        colorNameMap.put("floralwhite", "#fffaf0");
        colorNameMap.put("forestgreen", "#228b22");
        colorNameMap.put("fuchsia", "#ff00ff");
        colorNameMap.put("gainsboro", "#dcdcdc");
        colorNameMap.put("ghostwhite", "#f8f8ff");
        colorNameMap.put("gold", "#ffd700");
        colorNameMap.put("goldenrod", "#daa520");
        colorNameMap.put("gray", "#808080");
        colorNameMap.put("grey", "#808080");
        colorNameMap.put("green", "#008000");
        colorNameMap.put("greenyellow", "#adff2f");
        colorNameMap.put("honeydew", "#f0fff0");
        colorNameMap.put("hotpink", "#ff69b4");
        colorNameMap.put("indianred", "#cd5c5c");
        colorNameMap.put("indigo", "#4b0082");
        colorNameMap.put("ivory", "#fffff0");
        colorNameMap.put("khaki", "#f0e68c");
        colorNameMap.put("lavender", "#e6e6fa");
        colorNameMap.put("lavenderblush", "#fff0f5");
        colorNameMap.put("lawngreen", "#7cfc00");
        colorNameMap.put("lemonchiffon", "#fffacd");
        colorNameMap.put("lightblue", "#add8e6");
        colorNameMap.put("lightcoral", "#f08080");
        colorNameMap.put("lightcyan", "#e0ffff");
        colorNameMap.put("lightgoldenrodyellow", "#fafad2");
        colorNameMap.put("lightgray", "#d3d3d3");
        colorNameMap.put("lightgrey", "#d3d3d3");
        colorNameMap.put("lightgreen", "#90ee90");
        colorNameMap.put("lightpink", "#ffb6c1");
        colorNameMap.put("lightsalmon", "#ffa07a");
        colorNameMap.put("lightseagreen", "#20b2aa");
        colorNameMap.put("lightskyblue", "#87cefa");
        colorNameMap.put("lightslategray", "#778899");
        colorNameMap.put("lightslategrey", "#778899");
        colorNameMap.put("lightsteelblue", "#b0c4de");
        colorNameMap.put("lightyellow", "#ffffe0");
        colorNameMap.put("lime", "#00ff00");
        colorNameMap.put("limegreen", "#32cd32");
        colorNameMap.put("linen", "#faf0e6");
        colorNameMap.put("magenta", "#ff00ff");
        colorNameMap.put("maroon", "#800000");
        colorNameMap.put("mediumaquamarine", "#66cdaa");
        colorNameMap.put("mediumblue", "#0000cd");
        colorNameMap.put("mediumorchid", "#ba55d3");
        colorNameMap.put("mediumpurple", "#9370d8");
        colorNameMap.put("mediumseagreen", "#3cb371");
        colorNameMap.put("mediumslateblue", "#7b68ee");
        colorNameMap.put("mediumspringgreen", "#00fa9a");
        colorNameMap.put("mediumturquoise", "#48d1cc");
        colorNameMap.put("mediumvioletred", "#c71585");
        colorNameMap.put("midnightblue", "#191970");
        colorNameMap.put("mintcream", "#f5fffa");
        colorNameMap.put("mistyrose", "#ffe4e1");
        colorNameMap.put("moccasin", "#ffe4b5");
        colorNameMap.put("navajowhite", "#ffdead");
        colorNameMap.put("navy", "#000080");
        colorNameMap.put("oldlace", "#fdf5e6");
        colorNameMap.put("olive", "#808000");
        colorNameMap.put("olivedrab", "#6b8e23");
        colorNameMap.put("orange", "#ffa500");
        colorNameMap.put("orangered", "#ff4500");
        colorNameMap.put("orchid", "#da70d6");
        colorNameMap.put("palegoldenrod", "#eee8aa");
        colorNameMap.put("palegreen", "#98fb98");
        colorNameMap.put("paleturquoise", "#afeeee");
        colorNameMap.put("palevioletred", "#d87093");
        colorNameMap.put("papayawhip", "#ffefd5");
        colorNameMap.put("peachpuff", "#ffdab9");
        colorNameMap.put("peru", "#cd853f");
        colorNameMap.put("pink", "#ffc0cb");
        colorNameMap.put("plum", "#dda0dd");
        colorNameMap.put("powderblue", "#b0e0e6");
        colorNameMap.put("purple", "#800080");
        colorNameMap.put("red", "#ff0000");
        colorNameMap.put("rebeccapurple", "#663399");
        colorNameMap.put("rosybrown", "#bc8f8f");
        colorNameMap.put("royalblue", "#4169e1");
        colorNameMap.put("saddlebrown", "#8b4513");
        colorNameMap.put("salmon", "#fa8072");
        colorNameMap.put("sandybrown", "#f4a460");
        colorNameMap.put("seagreen", "#2e8b57");
        colorNameMap.put("seashell", "#fff5ee");
        colorNameMap.put("sienna", "#a0522d");
        colorNameMap.put("silver", "#c0c0c0");
        colorNameMap.put("skyblue", "#87ceeb");
        colorNameMap.put("slateblue", "#6a5acd");
        colorNameMap.put("slategray", "#708090");
        colorNameMap.put("slategrey", "#708090");
        colorNameMap.put("snow", "#fffafa");
        colorNameMap.put("springgreen", "#00ff7f");
        colorNameMap.put("steelblue", "#4682b4");
        colorNameMap.put("tan", "#d2b48c");
        colorNameMap.put("teal", "#008080");
        colorNameMap.put("thistle", "#d8bfd8");
        colorNameMap.put("tomato", "#ff6347");
        colorNameMap.put("turquoise", "#40e0d0");
        colorNameMap.put("violet", "#ee82ee");
        colorNameMap.put("wheat", "#f5deb3");
        colorNameMap.put("white", "#ffffff");
        colorNameMap.put("whitesmoke", "#f5f5f5");
        colorNameMap.put("yellow", "#ffff00");
        colorNameMap.put("yellowgreen", "#9acd32");
    }
}

