/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.R;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.MaskedMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MessageValidator {
    private static final String TAG = "MessageValidator";
    private boolean mIsClientOnlyMaskingEnabled = Configuration.getBoolean(R.bool.enable_client_only_masking);
    private Pattern mClientOnlyRegexPattern = null;
    private final String mClientOnlyMaskCharacter;
    private final boolean mIsRealTimeMaskingEnabled = Configuration.getBoolean(R.bool.enable_real_time_masking);
    private Pattern mRealTimeRegexPattern = null;
    private final String mRealTimeMaskCharacter;
    private final String mClientOnlySystemMessage;
    private final String mRealTimeSystemMessage;

    public MessageValidator(boolean isAuthenticated, String realTimeSystemMessage, String clientOnlySystemMessage) {
        String mRealTimeMaskRegex;
        String mClientOnlyMaskRegex;
        if (isAuthenticated) {
            this.mIsClientOnlyMaskingEnabled = false;
        }
        if (!TextUtils.isEmpty((CharSequence)(mClientOnlyMaskRegex = Configuration.getString(R.string.client_only_masking_regex)))) {
            try {
                this.mClientOnlyRegexPattern = Pattern.compile(mClientOnlyMaskRegex);
            }
            catch (PatternSyntaxException exception) {
                LPLog.INSTANCE.w(TAG, "Client only masking regex is invalid. aborting.", exception);
                this.mClientOnlyRegexPattern = null;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(mRealTimeMaskRegex = Configuration.getString(R.string.real_time_masking_regex)))) {
            try {
                this.mRealTimeRegexPattern = Pattern.compile(mRealTimeMaskRegex);
            }
            catch (PatternSyntaxException exception) {
                LPLog.INSTANCE.w(TAG, "Real time masking regex is invalid. aborting.", exception);
                this.mRealTimeRegexPattern = null;
            }
        }
        Context context = Infra.instance.getApplicationContext();
        this.mClientOnlyMaskCharacter = context.getString(R.string.client_only_mask_character);
        this.mRealTimeMaskCharacter = context.getString(R.string.real_time_mask_character);
        this.mRealTimeSystemMessage = realTimeSystemMessage;
        this.mClientOnlySystemMessage = clientOnlySystemMessage;
    }

    public MaskedMessage maskMessage(String message, boolean isMaskable) {
        if ((this.mIsClientOnlyMaskingEnabled || this.mIsRealTimeMaskingEnabled) && isMaskable) {
            MaskedMessage maskedMessage = this.maskRealTimeMessage(message);
            if (maskedMessage == null) {
                maskedMessage = this.maskClientOnlyMessage(message);
            }
            if (maskedMessage != null) {
                return maskedMessage;
            }
        }
        return this.getDefaultNotMaskedMessage(message);
    }

    private MaskedMessage maskClientOnlyMessage(String message) {
        if (!this.mIsClientOnlyMaskingEnabled || this.mClientOnlyRegexPattern == null || this.mClientOnlyMaskCharacter == null) {
            return null;
        }
        Matcher matcher = this.mClientOnlyRegexPattern.matcher(message);
        if (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            StringBuilder sb = new StringBuilder();
            for (int i = startIndex; i < endIndex; ++i) {
                sb.append(this.mClientOnlyMaskCharacter);
            }
            String maskedMessage = matcher.replaceAll(sb.toString());
            return new MaskedMessage(maskedMessage, message, true, this.mClientOnlySystemMessage);
        }
        return null;
    }

    private MaskedMessage maskRealTimeMessage(String message) {
        if (!this.mIsRealTimeMaskingEnabled || this.mRealTimeRegexPattern == null || this.mRealTimeMaskCharacter == null) {
            return null;
        }
        Matcher matcher = this.mRealTimeRegexPattern.matcher(message);
        if (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            StringBuilder sb = new StringBuilder();
            for (int i = startIndex; i < endIndex; ++i) {
                sb.append(this.mRealTimeMaskCharacter);
            }
            String maskedMessage = matcher.replaceAll(sb.toString());
            return new MaskedMessage(maskedMessage, maskedMessage, true, this.mRealTimeSystemMessage);
        }
        return null;
    }

    @NonNull
    private MaskedMessage getDefaultNotMaskedMessage(String message) {
        return new MaskedMessage(message, message, false, null);
    }
}

