package com.liveperson.infra.controller

import com.liveperson.infra.log.LPMobileLog
import java.util.*

/**
 * A manager class that is holding all currently playing audio.
 */
class PlayingAudioManager {

    companion object {
        private const val TAG = "PlayingAudioManager"
    }

    val mCurrentlyPlayingList: MutableSet<AudioPlayable>

    init {
        mCurrentlyPlayingList = HashSet()
    }

    /**
     * Add a playable object to this manager
     */
    private fun addPlaying(audioPlayable: AudioPlayable) {

        LPMobileLog.d(TAG, "addPlaying: adding $audioPlayable");

        mCurrentlyPlayingList.add(audioPlayable)

        LPMobileLog.d(TAG, "${toString()}")

    }

    /**
     * Add a playable object and stop all other currently playing
     */
    fun addPlayingAndStopOthers(audioPlayable: AudioPlayable) {

        LPMobileLog.d(TAG, "addPlayingAndStopOthers: adding $audioPlayable");

        stopAllCurrentlyPlaying()
        addPlaying(audioPlayable)

    }

    /**
     * Remove a playable object from this manager
     */
    fun removePlaying(audioPlayable: AudioPlayable) {

        LPMobileLog.d(TAG, "removePlaying: removing $audioPlayable");

        mCurrentlyPlayingList.remove(audioPlayable)

        LPMobileLog.d(TAG, "${toString()}")
    }

    /**
     * Stop the given playable object and remove it from this manager
     */
    fun stopPlaying(audioPlayable: AudioPlayable) {

        LPMobileLog.d(TAG, "stopPlaying: stopping and removing $audioPlayable");

        audioPlayable.stopPlaying()
        removePlaying(audioPlayable)
    }

    /**
     * Stop all playable objects currently in this manager (and remove them)
     */
    fun stopAllCurrentlyPlaying(){
        for (audioPlayable in mCurrentlyPlayingList) {
            stopPlaying(audioPlayable)
        }

        LPMobileLog.d(TAG, "${toString()}")
    }

    override fun toString(): String {

        return "Currently in list ${mCurrentlyPlayingList.size} items. $mCurrentlyPlayingList"
    }
}
