package com.liveperson.infra.log.logreporter.loggos.logsender;

import android.net.Uri;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.log.logreporter.loggos.LoggosMessage;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.LPJSONArrayBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;

import org.json.JSONArray;

import java.util.List;

/**
 * Created by nirni on 3/16/16.
 */
public class HttpLogSender extends LogSender {

	public static final String TAG = HttpLogSender.class.getSimpleName();

	private static final String LOGGOS_URL = "https://%s/api/loggos/log/";
	private static final String APP_NAME = "appName";
	private static final String MESSAGING_SDK = "messaging_SDK_Android";


	@Override
	public void sendBulk(String domain, final List<LoggosMessage> messages, List<String> certificates) {

		if ((domain == null) || (messages == null) || messages.isEmpty()) {
			LPMobileLog.d(TAG, "sendBulk: domain or message is empty. Did not send log");
			return;
		}

		// Build a json array from all messages
		JSONArray jsonArray = new JSONArray();
		for (LoggosMessage message : messages) {
			jsonArray.put(message.toJsonObject());
		}

		Uri fullUri = Uri.parse(String.format(LOGGOS_URL, domain)).buildUpon()
				.appendQueryParameter(APP_NAME, MESSAGING_SDK)
				.build();

		HttpPostRequest postRequest = new HttpPostRequest(fullUri.toString());
		postRequest.setBody(new LPJSONArrayBody(jsonArray));
		postRequest.setCertificatePinningKeys(certificates);
		postRequest.setCallback(new ICallback<String, Throwable>() {

			@Override
			public void onSuccess(String response) {

				LPMobileLog.i(TAG, "SendBulk onSuccess: Sent to loggos successfully "+ response) ;
				if (mCallback != null) {
					mCallback.onSuccess();
				}
			}

			@Override
			public void onError(Throwable exception) {

				LPMobileLog.d(TAG, "SendBulk onError: " + exception);
				if (mCallback != null) {
					mCallback.onError(messages, exception);
				}
			}
		});
		HttpHandler.execute(postRequest);

	}
}
